/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ICombinedCondition;
import org.freeplane.features.filter.condition.JCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisjunctConditions
extends ASelectableCondition
implements ICombinedCondition {
    static final String NAME = "disjunct_condition";
    private final ASelectableCondition[] conditions;

    static ASelectableCondition load(ConditionFactory conditionFactory, XMLElement element) {
        Vector<XMLElement> children = element.getChildren();
        ASelectableCondition[] conditions = new ASelectableCondition[children.size()];
        for (int i = 0; i < conditions.length; ++i) {
            ASelectableCondition condition = conditionFactory.loadCondition(children.get(i));
            if (condition == null) {
                return null;
            }
            conditions[i] = condition;
        }
        return new DisjunctConditions(conditions);
    }

    public DisjunctConditions(ASelectableCondition[] conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        for (ASelectableCondition condition : this.conditions) {
            if (!condition.checkNode(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JComponent createRendererComponent() {
        JCondition component = new JCondition();
        component.add(new JLabel("("));
        ASelectableCondition cond = this.conditions[0];
        JComponent rendererComponent = cond.createShortRendererComponent();
        component.add(rendererComponent);
        for (int i = 1; i < this.conditions.length; ++i) {
            String or = TextUtils.getText("filter_or");
            String text = ' ' + or + ' ';
            component.add(new JLabel(text));
            cond = this.conditions[i];
            rendererComponent = cond.createRendererComponent();
            component.add(rendererComponent);
        }
        component.add(new JLabel(")"));
        return component;
    }

    @Override
    public void fillXML(XMLElement child) {
        for (ASelectableCondition condition : this.conditions) {
            condition.toXml(child);
        }
    }

    @Override
    protected String createDescription() {
        return NAME;
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public Collection<ASelectableCondition> split() {
        return Arrays.asList(this.conditions);
    }
}

