/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.icon.UIIcon;

public class DefaultConditionRenderer
implements ListCellRenderer,
TableCellRenderer {
    private final String noValueText;
    private final boolean renderNamedConditions;

    public DefaultConditionRenderer(String noValueText, boolean renderNamedConditions) {
        this.noValueText = noValueText;
        this.renderNamedConditions = renderNamedConditions;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component cellRendererComponent = this.getCellRendererComponent(value, isSelected);
        if (isSelected) {
            cellRendererComponent.setBackground(list.getSelectionBackground());
            cellRendererComponent.setForeground(list.getSelectionForeground());
        } else {
            cellRendererComponent.setBackground(list.getBackground());
            cellRendererComponent.setForeground(list.getForeground());
        }
        return cellRendererComponent;
    }

    private Component getCellRendererComponent(Object value, boolean isSelected) {
        JComponent component;
        if (value == null) {
            component = new JLabel(this.noValueText);
        } else if (value instanceof UIIcon) {
            component = new JLabel(((UIIcon)value).getIcon());
        } else if (value instanceof ASelectableCondition) {
            ASelectableCondition cond = (ASelectableCondition)value;
            String userName = cond.getUserName();
            if (this.renderNamedConditions || userName == null) {
                component = cond.getListCellRendererComponent();
            } else {
                component = new JLabel(userName);
                component.setToolTipText(cond.createDescription());
            }
        } else {
            component = new JLabel(value.toString());
        }
        component.setOpaque(true);
        component.setAlignmentX(0.0f);
        return component;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cellRendererComponent = this.getCellRendererComponent(value, isSelected);
        if (isSelected) {
            cellRendererComponent.setBackground(table.getSelectionBackground());
            cellRendererComponent.setForeground(table.getSelectionForeground());
        } else {
            cellRendererComponent.setBackground(table.getBackground());
            cellRendererComponent.setForeground(table.getForeground());
        }
        return cellRendererComponent;
    }
}

