/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

final class QuickFindAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final FilterConditionEditor filterEditor;
    private final FilterController filterController;
    private final MapController.Direction direction;

    QuickFindAction(FilterController filterController, FilterConditionEditor quickEditor, MapController.Direction direction) {
        super("QuickFindAction." + (Object)((Object)direction));
        this.filterController = filterController;
        this.filterEditor = quickEditor;
        this.direction = direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAction(boolean reFocusSearchInputField) {
        NodeModel next;
        ASelectableCondition condition = this.filterEditor.getCondition();
        if (condition == null) {
            return;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            return;
        }
        NodeModel selected = selection.getSelected();
        try {
            this.filterEditor.setSearchingBusyCursor();
            next = this.filterController.findNext(selected, null, this.direction, condition);
        }
        finally {
            this.filterEditor.setSearchingDefaultCursor();
        }
        if (next != null) {
            MapController mapController = Controller.getCurrentModeController().getMapController();
            mapController.displayNode(next);
            selection.selectAsTheOnlyOneSelected(next);
            if (reFocusSearchInputField) {
                this.filterEditor.focusInputField(false);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.executeAction(false);
    }
}

