/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.freeplane.features.filter.EditDistanceStringMatchingStrategy;
import org.freeplane.features.filter.StringMatchingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoDamerauLevenshtein
implements EditDistanceStringMatchingStrategy {
    private int[][] matrix;
    private String searchTerm;
    private String searchText;
    private final int costIndel = 1;
    private final int costMismatch = 1;
    private final int costTranspos = 1;
    private EditDistanceStringMatchingStrategy.Type type;
    private Stack<Alignment> alignmentsInProgress;
    private ArrayList<Alignment> alignmentsDone;

    private boolean isMatch(int i, int j) {
        char row;
        char col = this.searchTerm.charAt(i - 1);
        return col == (row = this.searchText.charAt(j - 1)) || row == '-';
    }

    @Override
    public int distance() {
        int j;
        int i;
        this.matrix = new int[this.searchTerm.length() + 1][this.searchText.length() + 1];
        for (i = 0; i <= this.searchTerm.length(); ++i) {
            this.matrix[i][0] = i * 1;
        }
        if (this.type == EditDistanceStringMatchingStrategy.Type.Global) {
            for (int j2 = 1; j2 <= this.searchText.length(); ++j2) {
                this.matrix[0][j2] = j2 * 1;
            }
        } else if (this.type == EditDistanceStringMatchingStrategy.Type.SemiGlobal) {
            Arrays.fill(this.matrix[0], 0);
        }
        for (i = 1; i <= this.searchTerm.length(); ++i) {
            for (j = 1; j <= this.searchText.length(); ++j) {
                int cost_try_match = this.matrix[i - 1][j - 1] + (this.isMatch(i, j) ? 0 : 1);
                int cost_ins = this.matrix[i - 1][j] + 1;
                int cost_del = this.matrix[i][j - 1] + 1;
                this.matrix[i][j] = Math.min(cost_try_match, Math.min(cost_ins, cost_del));
                if (i < 2 || j < 2 || this.searchTerm.charAt(i - 2) != this.searchText.charAt(j - 1) || this.searchTerm.charAt(i - 1) != this.searchText.charAt(j - 2)) continue;
                this.matrix[i][j] = Math.min(this.matrix[i][j], this.matrix[i - 2][j - 2] + 1);
            }
        }
        if (this.type == EditDistanceStringMatchingStrategy.Type.Global) {
            return this.matrix[this.searchTerm.length()][this.searchText.length()];
        }
        int min = Integer.MAX_VALUE;
        for (j = 1; j <= this.searchText.length() + 1; ++j) {
            min = Math.min(min, this.matrix[this.searchTerm.length()][j - 1]);
        }
        return min;
    }

    private void writeMatrix(int[][] H) {
        for (int i = 0; i < H.length; ++i) {
            for (int j = 0; j < H[0].length; ++j) {
                System.out.format(" %3d", H[i][j]);
            }
            System.out.println();
        }
    }

    public List<Alignment> computeAlignments(double minProb) {
        this.alignmentsInProgress = new Stack();
        this.alignmentsDone = new ArrayList();
        int dist = this.distance();
        if (this.type == EditDistanceStringMatchingStrategy.Type.Global && (double)this.getMatchProb(dist) > minProb) {
            this.alignmentsInProgress.push(new Alignment("", "", this.getMatchProb(dist), 0, this.searchText.length(), this.searchTerm.length(), this.searchText.length()));
        } else {
            StringBuilder searchTermSuffix = new StringBuilder();
            StringBuilder searchTextSuffix = new StringBuilder();
            for (int c = this.searchText.length() + 1; c >= 1; --c) {
                double prob;
                if (c <= this.searchText.length()) {
                    searchTermSuffix.append('-');
                    searchTextSuffix.insert(0, this.searchText.charAt(c - 1));
                }
                if (!((prob = (double)this.getMatchProb(this.matrix[this.searchTerm.length()][c - 1])) > minProb)) continue;
                this.alignmentsInProgress.push(new Alignment(searchTermSuffix.toString(), searchTextSuffix.toString(), prob, 0, this.searchText.length() - searchTextSuffix.length(), this.searchTerm.length(), c - 1));
            }
        }
        while (!this.alignmentsInProgress.isEmpty()) {
            this.developAlignment(this.alignmentsInProgress.pop());
        }
        this.alignmentsDone = PseudoDamerauLevenshtein.filterAlignments(this.alignmentsDone);
        PseudoDamerauLevenshtein.sortAlignments(this.alignmentsDone);
        this.matrix = null;
        return this.alignmentsDone;
    }

    static ArrayList<Alignment> filterAlignments(ArrayList<Alignment> alignments) {
        if (alignments.isEmpty()) {
            return new ArrayList<Alignment>();
        }
        Collections.sort(alignments, Collections.reverseOrder());
        ArrayList<Alignment> clusters = new ArrayList<Alignment>(alignments.size());
        clusters.add(alignments.get(0));
        alignments.remove(0);
        for (Alignment ali : alignments) {
            boolean found_cluster = false;
            for (int j = 0; j < clusters.size(); ++j) {
                if (!ali.overlapsWith(clusters.get(j))) continue;
                found_cluster = true;
                if (ali.compareTo(clusters.get(j)) <= 0) continue;
                clusters.set(j, ali);
            }
            if (found_cluster) continue;
            clusters.add(ali);
        }
        return clusters;
    }

    static void sortAlignments(ArrayList<Alignment> alignments) {
        Collections.sort(alignments, new Comparator<Alignment>(){

            @Override
            public int compare(Alignment o1, Alignment o2) {
                return new Integer(o1.matchStart).compareTo(o2.matchStart);
            }
        });
    }

    private void developAlignment(Alignment ali) {
        System.out.format("developAlignment(term=%s, text=%s, r=%d, c=%d)", ali.searchTermString, ali.searchTextString, ali.r, ali.c);
        if (ali.r == 0 && ali.c == 0) {
            this.alignmentsDone.add(ali);
            System.out.println();
            ali.print();
        } else {
            if (ali.r >= 1 && ali.c >= 1 && this.matrix[ali.r][ali.c] == this.matrix[ali.r - 1][ali.c - 1] + (this.isMatch(ali.r, ali.c) ? 0 : 1)) {
                System.out.format("=> match/mismatch\n", new Object[0]);
                this.alignmentsInProgress.push(new Alignment(this.searchTerm.charAt(ali.r - 1) + ali.searchTermString, this.searchText.charAt(ali.c - 1) + ali.searchTextString, ali.prob, ali.matchStart, ali.matchEnd, ali.r - 1, ali.c - 1));
            }
            if (this.type == EditDistanceStringMatchingStrategy.Type.SemiGlobal && ali.r == 0) {
                System.out.format("=> insertions at beginning\n", new Object[0]);
                int matchStart = ali.matchStart;
                StringBuilder searchTermPrefix = new StringBuilder();
                StringBuilder searchTextPrefix = new StringBuilder();
                for (int c = ali.c; c > 0; --c) {
                    searchTermPrefix.append('-');
                    searchTextPrefix.insert(0, this.searchText.charAt(c - 1));
                    ++matchStart;
                }
                this.alignmentsInProgress.push(new Alignment(searchTermPrefix.toString() + ali.searchTermString, searchTextPrefix.toString() + ali.searchTextString, ali.prob, matchStart, ali.matchEnd, 0, 0));
            }
            if (ali.c >= 1 && this.matrix[ali.r][ali.c] == this.matrix[ali.r][ali.c - 1] + 1) {
                System.out.format("=> insertion\n", new Object[0]);
                this.alignmentsInProgress.push(new Alignment("-" + ali.searchTermString, this.searchText.charAt(ali.c - 1) + ali.searchTextString, ali.prob, ali.matchStart, ali.matchEnd, ali.r, ali.c - 1));
            }
            if (ali.r >= 1 && this.matrix[ali.r][ali.c] == this.matrix[ali.r - 1][ali.c] + 1) {
                System.out.format("=> deletion\n", new Object[0]);
                this.alignmentsInProgress.push(new Alignment(this.searchTerm.charAt(ali.r - 1) + ali.searchTermString, "-" + ali.searchTextString, ali.prob, ali.matchStart, ali.matchEnd, ali.r - 1, ali.c));
            }
            if (ali.r >= 2 && ali.c >= 2 && this.matrix[ali.r][ali.c] == this.matrix[ali.r - 2][ali.c - 2] + 1 && this.searchTerm.charAt(ali.r - 2) == this.searchText.charAt(ali.c - 1) && this.searchTerm.charAt(ali.r - 1) == this.searchText.charAt(ali.c - 2)) {
                System.out.format("=> transposition\n", new Object[0]);
                this.alignmentsInProgress.push(new Alignment(this.searchTerm.substring(ali.r - 2, ali.r) + ali.searchTermString, this.searchText.substring(ali.c - 2, ali.c) + ali.searchTextString, ali.prob, ali.matchStart, ali.matchEnd, ali.r - 2, ali.c - 2));
            }
        }
    }

    private float getMatchProb(int distance) {
        if (this.type == EditDistanceStringMatchingStrategy.Type.SemiGlobal) {
            return 1.0f - (float)distance / (float)this.searchTerm.length();
        }
        return 1.0f - (float)distance / (float)Math.min(this.searchTerm.length(), this.searchText.length());
    }

    @Override
    public float matchProb() {
        int dist = this.distance();
        this.matrix = null;
        return this.getMatchProb(dist);
    }

    @Override
    public void init(String searchTerm, String searchText, boolean subStringMatch, boolean caseSensitive) {
        if (searchTerm == null || searchText == null) {
            throw new IllegalArgumentException("Null searchText/searchTerm!");
        }
        if (caseSensitive) {
            this.searchTerm = searchTerm;
            this.searchText = searchText;
        } else {
            this.searchTerm = searchTerm.toLowerCase();
            this.searchText = searchText.toLowerCase();
        }
        this.type = subStringMatch ? EditDistanceStringMatchingStrategy.Type.SemiGlobal : EditDistanceStringMatchingStrategy.Type.Global;
    }

    @Override
    public boolean matches(String searchTerm, String searchText, boolean subStringMatch, boolean caseSensitive) {
        this.init(searchTerm, searchText, subStringMatch, caseSensitive);
        return (double)this.matchProb() > StringMatchingStrategy.APPROXIMATE_MATCHING_MINPROB;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Alignment
    implements Comparable<Alignment> {
        private final String searchTermString;
        private final String searchTextString;
        private final double prob;
        private final int matchStart;
        private final int matchEnd;
        private final int r;
        private final int c;

        public int getMatchStart() {
            return this.matchStart;
        }

        public int getMatchEnd() {
            return this.matchEnd;
        }

        public boolean overlapsWith(Alignment other) {
            return this.matchStart <= other.matchStart && other.matchStart <= this.matchEnd - 1 || other.matchStart <= this.matchStart && this.matchStart <= other.matchEnd - 1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.c;
            result = 31 * result + this.matchEnd;
            result = 31 * result + this.matchStart;
            long temp = Double.doubleToLongBits(this.prob);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.r;
            result = 31 * result + (this.searchTermString == null ? 0 : this.searchTermString.hashCode());
            result = 31 * result + (this.searchTextString == null ? 0 : this.searchTextString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Alignment other = (Alignment)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.c != other.c) {
                return false;
            }
            if (this.matchEnd != other.matchEnd) {
                return false;
            }
            if (this.matchStart != other.matchStart) {
                return false;
            }
            if (Double.doubleToLongBits(this.prob) != Double.doubleToLongBits(other.prob)) {
                return false;
            }
            if (this.r != other.r) {
                return false;
            }
            if (this.searchTermString == null ? other.searchTermString != null : !this.searchTermString.equals(other.searchTermString)) {
                return false;
            }
            return !(this.searchTextString == null ? other.searchTextString != null : !this.searchTextString.equals(other.searchTextString));
        }

        public String getMatch() {
            return PseudoDamerauLevenshtein.this.searchText.substring(this.matchStart, this.matchEnd);
        }

        @Override
        public int compareTo(Alignment other) {
            if (this.prob == other.prob) {
                return new Integer(this.getMatch().length()).compareTo(new Integer(other.getMatch().length()));
            }
            return new Double(this.prob).compareTo(new Double(other.prob));
        }

        public void print() {
            System.out.format("Alignment@%x[%.2f]:\n%s\n%s\n=> matches '%s' [%d,%d]\n", this.hashCode(), this.prob, this.searchTermString, this.searchTextString, this.getMatch(), this.matchStart, this.matchEnd);
        }

        public String toString() {
            return String.format("Ali@%x[%s,%.2f,%d,%d]", this.hashCode(), this.getMatch(), this.prob, this.matchStart, this.matchEnd);
        }

        public Alignment(String searchTermString, String searchTextString, double prob, int matchStart, int matchEnd, int r, int c) {
            this.searchTermString = searchTermString;
            this.searchTextString = searchTextString;
            this.prob = prob;
            this.matchStart = matchStart;
            this.matchEnd = matchEnd;
            this.r = r;
            this.c = c;
        }

        private PseudoDamerauLevenshtein getOuterType() {
            return PseudoDamerauLevenshtein.this;
        }
    }
}

