/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class FindAction
extends AFreeplaneAction {
    static final String KEY = "FindAction";
    private static final long serialVersionUID = 1L;
    private FilterConditionEditor editor;

    public FindAction() {
        super(KEY);
    }

    public void actionPerformed(ActionEvent e) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            return;
        }
        NodeModel start = selection.getSelected();
        if (this.editor == null) {
            this.editor = new FilterConditionEditor(FilterController.getCurrentFilterController());
            this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        } else {
            this.editor.mapChanged(start.getMap());
        }
        this.editor.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                JComponent component = event.getComponent();
                final Window windowAncestor = SwingUtilities.getWindowAncestor(component);
                if (windowAncestor.isFocused()) {
                    FindAction.this.editor.focusInputField(true);
                } else {
                    windowAncestor.addWindowFocusListener(new WindowFocusListener(){

                        public void windowLostFocus(WindowEvent e) {
                        }

                        public void windowGainedFocus(WindowEvent e) {
                            windowAncestor.removeWindowFocusListener(this);
                            FindAction.this.editor.focusInputField(true);
                        }
                    });
                    windowAncestor.toFront();
                }
                FindAction.this.editor.removeAncestorListener(this);
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        int run = UITools.showConfirmDialog(start, this.editor, TextUtils.getText("FindAction.text"), 2, -1);
        Container parent = this.editor.getParent();
        if (parent != null) {
            parent.remove(this.editor);
        }
        if (run != 0) {
            return;
        }
        ASelectableCondition condition = this.editor.getCondition();
        this.findFirst(condition);
    }

    void findFirst(ASelectableCondition condition) {
        FindNodeList info = FindNodeList.create(Controller.getCurrentController().getMap());
        info.condition = condition;
        if (info.condition == null) {
            return;
        }
        info.rootID = Controller.getCurrentController().getSelection().getSelected().createID();
        this.findNext();
    }

    void findNext() {
        MapModel map = Controller.getCurrentController().getMap();
        FindNodeList info = FindNodeList.get(map);
        if (info == null || info.condition == null) {
            this.displayNoPreviousFindMessage();
            return;
        }
        FilterController filterController = FilterController.getCurrentFilterController();
        NodeModel start = Controller.getCurrentController().getSelection().getSelected();
        NodeModel root = map.getNodeForID(info.rootID);
        if (root == null) {
            info.condition = null;
            this.displayNoPreviousFindMessage();
            return;
        }
        NodeModel n = start;
        while (!root.equals(n)) {
            if (n == null) {
                info.condition = null;
                this.displayNoPreviousFindMessage();
                return;
            }
            n = n.getParentNode();
        }
        NodeModel next = filterController.findNext(start, null, MapController.Direction.FORWARD, info.condition);
        if (next == null) {
            this.displayNotFoundMessage(root, info.condition);
            return;
        }
        this.displayNode(info, next);
    }

    private void displayNoPreviousFindMessage() {
        UITools.informationMessage(Controller.getCurrentController().getViewController().getFrame(), TextUtils.getText("no_previous_find"));
    }

    private void displayNode(FindNodeList info, NodeModel node) {
        String oldPathNodeID;
        NodeModel oldPathNode;
        MapModel map = node.getMap();
        LinkedList<String> nodesUnfoldedByDisplay = new LinkedList<String>();
        NodeModel nodeOnPath = null;
        for (nodeOnPath = node; nodeOnPath != null && !info.nodesUnfoldedByDisplay.contains(nodeOnPath.createID()); nodeOnPath = nodeOnPath.getParentNode()) {
            if (!Controller.getCurrentModeController().getMapController().isFolded(nodeOnPath)) continue;
            nodesUnfoldedByDisplay.add(nodeOnPath.createID());
        }
        ListIterator<String> oldPathIterator = info.nodesUnfoldedByDisplay.listIterator(info.nodesUnfoldedByDisplay.size());
        while (oldPathIterator.hasPrevious() && ((oldPathNode = map.getNodeForID(oldPathNodeID = oldPathIterator.previous())) == null || !oldPathNode.equals(nodeOnPath))) {
            oldPathIterator.remove();
            if (oldPathNode == null) continue;
            Controller.getCurrentModeController().getMapController().setFolded(oldPathNode, true);
        }
        info.nodesUnfoldedByDisplay.addAll(nodesUnfoldedByDisplay);
        Controller.getCurrentModeController().getMapController().select(node);
    }

    private void displayNotFoundMessage(NodeModel start, ICondition condition) {
        String message = TextUtils.format("no_more_found_from", condition.toString(), this.getFindFromText(start));
        UITools.informationMessage(Controller.getCurrentController().getViewController().getFrame(), message);
    }

    public String getFindFromText(NodeModel node) {
        String plainNodeText = node.toString().replaceAll("\n", " ");
        return plainNodeText.length() <= 30 ? plainNodeText : plainNodeText.substring(0, 30) + "...";
    }

    private static class FindNodeList
    implements IExtension {
        String rootID;
        final LinkedList<String> nodesUnfoldedByDisplay = new LinkedList();
        ASelectableCondition condition;

        private FindNodeList() {
        }

        static FindNodeList create(MapModel map) {
            FindNodeList list = FindNodeList.get(map);
            if (list == null) {
                list = new FindNodeList();
                map.addExtension(list);
            }
            return list;
        }

        private static FindNodeList get(MapModel map) {
            if (map == null) {
                return null;
            }
            FindNodeList list = map.getExtension(FindNodeList.class);
            return list;
        }
    }
}

