/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import org.freeplane.core.ui.IMenuContributor;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.features.filter.ApplyNamedFilterAction;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.mode.ModeController;

public class FilterMenuBuilder
implements IMenuContributor {
    private static final String MENU_USER_DEFINED_FILTERS = "menu_user_defined_filters";
    private final FilterController filterController;

    FilterMenuBuilder(FilterController filtercontroller) {
        this.filterController = filtercontroller;
    }

    public void updateMenus(ModeController modeController, MenuBuilder builder) {
        if (builder.get(MENU_USER_DEFINED_FILTERS) == null) {
            return;
        }
        builder.removeChildElements(MENU_USER_DEFINED_FILTERS);
        DefaultComboBoxModel filterConditions = this.filterController.getFilterConditions();
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = 0; i < filterConditions.getSize(); ++i) {
            ASelectableCondition condition = (ASelectableCondition)filterConditions.getElementAt(i);
            String conditionName = condition.getUserName();
            if (conditionName == null || !usedNames.add(conditionName)) continue;
            ApplyNamedFilterAction action = new ApplyNamedFilterAction(this.filterController, condition);
            builder.addAction(MENU_USER_DEFINED_FILTERS, action, 0);
        }
    }
}

