/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;

public class FilterConditionEditor
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_FILTER_MATCH_CASE = "filter_match_case";
    private static final String PROPERTY_FILTER_MATCH_CASE_TOOLTIP = "filter_match_case_tooltip";
    private static final String PROPERTY_FILTER_APPROXIMATE_MATCH = "filter_match_approximately";
    private static final String PROPERTY_FILTER_APPROXIMATE_MATCH_TOOLTIP = "filter_match_approximately_tooltip";
    private final JCheckBox caseSensitive;
    private final JCheckBox approximateMatching;
    private final JComboBox elementaryConditions;
    private final FilterController filterController;
    private final JComboBox filteredPropertiesComponent;
    private final ExtendedComboBoxModel filteredPropertiesModel;
    private WeakReference<MapModel> lastMap;
    private final JComboBox values;
    private ActionListener enterKeyActionListener;

    private void setValuesEnterKeyListener() {
        if (this.enterKeyActionListener != null) {
            this.values.getEditor().removeActionListener(this.enterKeyActionListener);
            this.values.getEditor().addActionListener(this.enterKeyActionListener);
        }
    }

    public void setSearchingBusyCursor() {
        RootPaneContainer root = (RootPaneContainer)((Object)this.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        root.getGlassPane().setVisible(true);
    }

    public void setSearchingDefaultCursor() {
        RootPaneContainer root = (RootPaneContainer)((Object)this.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getDefaultCursor());
        root.getGlassPane().setVisible(false);
    }

    private void setValuesEditor() {
        Object selectedProperty = this.filteredPropertiesComponent.getSelectedItem();
        IElementaryConditionController conditionController = this.filterController.getConditionFactory().getConditionController(selectedProperty);
        NamedObject selectedCondition = (NamedObject)this.elementaryConditions.getSelectedItem();
        boolean canSelectValues = conditionController.canSelectValues(selectedProperty, selectedCondition);
        this.values.setEnabled(canSelectValues);
        this.values.setEditable(false);
        this.values.setModel(conditionController.getValuesForProperty(selectedProperty, selectedCondition));
        ComboBoxEditor valueEditor = conditionController.getValueEditor(selectedProperty, selectedCondition);
        this.values.setEditor(valueEditor != null ? valueEditor : new FixedBasicComboBoxEditor());
        this.setValuesEnterKeyListener();
        ListCellRenderer valueRenderer = conditionController.getValueRenderer(selectedProperty, selectedCondition);
        this.values.setRenderer(valueRenderer != null ? valueRenderer : this.filterController.getConditionRenderer());
        this.values.setEditable(conditionController.canEditValues(selectedProperty, selectedCondition));
        if (this.values.getModel().getSize() > 0) {
            this.values.setSelectedIndex(0);
        }
        this.caseSensitive.setEnabled(canSelectValues && conditionController.isCaseDependent(selectedProperty, selectedCondition));
        this.approximateMatching.setEnabled(canSelectValues && conditionController.supportsApproximateMatching(selectedProperty, selectedCondition));
    }

    public FilterConditionEditor(FilterController filterController) {
        this(filterController, 5, false);
    }

    public FilterConditionEditor(FilterController filterController, int borderWidth, boolean horizontal) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, borderWidth, 0, borderWidth);
        this.filterController = filterController;
        this.filteredPropertiesComponent = new JComboBox();
        this.filteredPropertiesModel = new ExtendedComboBoxModel();
        this.filteredPropertiesComponent.setModel(this.filteredPropertiesModel);
        this.filteredPropertiesComponent.addItemListener(new FilteredPropertyChangeListener());
        this.add(Box.createHorizontalGlue(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.filteredPropertiesComponent.setAlignmentY(0.0f);
        this.add((Component)this.filteredPropertiesComponent, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.filteredPropertiesComponent.setRenderer(filterController.getConditionRenderer());
        this.elementaryConditions = new JComboBox();
        this.elementaryConditions.addItemListener(new ElementaryConditionChangeListener());
        this.elementaryConditions.setAlignmentY(0.0f);
        this.add((Component)this.elementaryConditions, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.elementaryConditions.setRenderer(filterController.getConditionRenderer());
        this.values = new JComboBox();
        this.values.setPreferredSize(new Dimension(240, 20));
        gridBagConstraints.anchor = 17;
        this.add((Component)this.values, gridBagConstraints);
        if (horizontal) {
            ++gridBagConstraints.gridx;
        } else {
            ++gridBagConstraints.gridy;
        }
        this.values.setEditable(true);
        this.setValuesEnterKeyListener();
        JPanel ignoreCaseAndApproximateMatchingPanel = new JPanel();
        ignoreCaseAndApproximateMatchingPanel.setLayout(new FlowLayout(0, 0, 0));
        this.caseSensitive = new JCheckBox();
        this.caseSensitive.setModel(filterController.getCaseSensitiveButtonModel());
        this.caseSensitive.setToolTipText(TextUtils.getRawText(PROPERTY_FILTER_MATCH_CASE_TOOLTIP));
        ignoreCaseAndApproximateMatchingPanel.add(this.caseSensitive);
        MenuBuilder.setLabelAndMnemonic(this.caseSensitive, TextUtils.getRawText(PROPERTY_FILTER_MATCH_CASE));
        this.caseSensitive.setSelected(ResourceController.getResourceController().getBooleanProperty(PROPERTY_FILTER_MATCH_CASE));
        this.approximateMatching = new JCheckBox();
        this.approximateMatching.setModel(filterController.getApproximateMatchingButtonModel());
        this.approximateMatching.setToolTipText(TextUtils.getRawText(PROPERTY_FILTER_APPROXIMATE_MATCH_TOOLTIP));
        MenuBuilder.setLabelAndMnemonic(this.approximateMatching, TextUtils.getRawText(PROPERTY_FILTER_APPROXIMATE_MATCH));
        ignoreCaseAndApproximateMatchingPanel.add(this.approximateMatching);
        this.approximateMatching.setSelected(ResourceController.getResourceController().getBooleanProperty(PROPERTY_FILTER_APPROXIMATE_MATCH));
        this.mapChanged(Controller.getCurrentController().getMap());
        this.add((Component)ignoreCaseAndApproximateMatchingPanel, gridBagConstraints);
    }

    public void focusInputField(boolean selectAll) {
        if (this.values.isEnabled()) {
            this.values.requestFocusInWindow();
            Component editorComponent = this.values.getEditor().getEditorComponent();
            if (selectAll && editorComponent instanceof JTextComponent) {
                ((JTextComponent)editorComponent).selectAll();
            }
            return;
        }
    }

    public boolean isInputFieldFocused() {
        if (this.values.isFocusOwner()) {
            return true;
        }
        return this.values.isPopupVisible() || this.values.getEditor().getEditorComponent().isFocusOwner();
    }

    public ASelectableCondition getCondition() {
        Object value = this.values.isEditable() ? this.values.getEditor().getItem() : this.values.getSelectedItem();
        if (value == null) {
            value = "";
        }
        NamedObject simpleCond = (NamedObject)this.elementaryConditions.getSelectedItem();
        boolean matchCase = this.caseSensitive.isSelected();
        boolean matchApproximately = this.approximateMatching.isSelected();
        ResourceController.getResourceController().setProperty(PROPERTY_FILTER_MATCH_CASE, matchCase);
        Object selectedItem = this.filteredPropertiesComponent.getSelectedItem();
        ASelectableCondition newCond = this.filterController.getConditionFactory().createCondition(selectedItem, simpleCond, value, matchCase, matchApproximately);
        if (this.values.isEditable() && !value.equals("")) {
            DefaultComboBoxModel list = (DefaultComboBoxModel)this.values.getModel();
            int indexOfValue = list.getIndexOf(value);
            if (indexOfValue > 0) {
                list.removeElementAt(indexOfValue);
            }
            if (indexOfValue == -1 || list.getIndexOf(value) != indexOfValue) {
                this.values.insertItemAt(value, 0);
                this.values.setSelectedIndex(0);
            } else if (indexOfValue != -1) {
                this.values.setSelectedIndex(indexOfValue);
            }
            if (this.values.getItemCount() >= 10) {
                this.values.removeItemAt(9);
            }
        }
        return newCond;
    }

    public void mapChanged(MapModel newMap) {
        if (newMap != null) {
            if (this.lastMap != null && this.lastMap.get() == newMap) {
                return;
            }
            this.filteredPropertiesModel.removeAllElements();
            Iterator<IElementaryConditionController> conditionIterator = this.filterController.getConditionFactory().conditionIterator();
            while (conditionIterator.hasNext()) {
                IElementaryConditionController next = conditionIterator.next();
                this.filteredPropertiesModel.addExtensionList(next.getFilteredProperties());
                this.filteredPropertiesModel.setSelectedItem(this.filteredPropertiesModel.getElementAt(0));
            }
        } else {
            this.filteredPropertiesComponent.setSelectedIndex(-1);
            this.filteredPropertiesModel.setExtensionList(null);
        }
        this.lastMap = new WeakReference<MapModel>(newMap);
    }

    public void setEnterKeyActionListener(ActionListener enterKeyActionListener) {
        if (enterKeyActionListener == null) {
            throw new NullPointerException("null value in setEnterKeyActionListener()!");
        }
        if (this.enterKeyActionListener != null) {
            this.values.getEditor().removeActionListener(this.enterKeyActionListener);
        }
        this.enterKeyActionListener = enterKeyActionListener;
        this.values.getEditor().addActionListener(enterKeyActionListener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            c.setEnabled(enabled);
            if (!(c instanceof JComboBox)) continue;
            ((JComboBox)c).getEditor().getEditorComponent().setEnabled(enabled);
        }
    }

    private class FilteredPropertyChangeListener
    implements ItemListener {
        private FilteredPropertyChangeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object selectedProperty = FilterConditionEditor.this.filteredPropertiesComponent.getSelectedItem();
                IElementaryConditionController conditionController = FilterConditionEditor.this.filterController.getConditionFactory().getConditionController(selectedProperty);
                ComboBoxModel simpleConditionComboBoxModel = conditionController.getConditionsForProperty(selectedProperty);
                FilterConditionEditor.this.elementaryConditions.setModel(simpleConditionComboBoxModel);
                FilterConditionEditor.this.elementaryConditions.setEnabled(simpleConditionComboBoxModel.getSize() > 0);
                FilterConditionEditor.this.setValuesEditor();
                return;
            }
        }
    }

    private class ElementaryConditionChangeListener
    implements ItemListener {
        private ElementaryConditionChangeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                FilterConditionEditor.this.setValuesEditor();
            }
        }
    }
}

