/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.Arrays;
import org.freeplane.features.filter.EditDistanceStringMatchingStrategy;
import org.freeplane.features.filter.StringMatchingStrategy;

public class DamerauLevenshtein
implements EditDistanceStringMatchingStrategy {
    private String searchTerm;
    private String searchText;
    private EditDistanceStringMatchingStrategy.Type type;
    private int alphabetLength;

    public int distance() {
        int INFINITY = this.searchTerm.length() + this.searchText.length();
        int[][] H = new int[this.searchTerm.length() + 2][this.searchText.length() + 2];
        H[0][0] = INFINITY;
        for (int i = 0; i <= this.searchTerm.length(); ++i) {
            H[i + 1][1] = i;
            H[i + 1][0] = INFINITY;
        }
        for (int j = 0; j <= this.searchText.length(); ++j) {
            H[1][j + 1] = this.type == EditDistanceStringMatchingStrategy.Type.Global ? j : 0;
            H[0][j + 1] = INFINITY;
        }
        int[] DA = new int[this.alphabetLength];
        Arrays.fill(DA, 0);
        for (int i = 1; i <= this.searchTerm.length(); ++i) {
            int DB = 0;
            for (int j = 1; j <= this.searchText.length(); ++j) {
                int d;
                int i1 = DA[this.searchText.charAt(j - 1)];
                int j1 = DB;
                int n = d = this.searchTerm.charAt(i - 1) == this.searchText.charAt(j - 1) ? 0 : 1;
                if (d == 0) {
                    DB = j;
                }
                H[i + 1][j + 1] = DamerauLevenshtein.min(H[i][j] + d, H[i + 1][j] + 1, H[i][j + 1] + 1, H[i1][j1] + (i - i1 - 1) + 1 + (j - j1 - 1));
            }
            DA[this.searchTerm.charAt((int)(i - 1))] = i;
        }
        if (this.type == EditDistanceStringMatchingStrategy.Type.Global) {
            return H[this.searchTerm.length() + 1][this.searchText.length() + 1];
        }
        int min = Integer.MAX_VALUE;
        for (int j = 1; j <= this.searchText.length() + 1; ++j) {
            min = Math.min(min, H[this.searchTerm.length() + 1][j]);
        }
        return min;
    }

    private void writeMatrix(int[][] H) {
        for (int i = 0; i < H.length; ++i) {
            for (int j = 0; j < H[0].length; ++j) {
                System.out.format(" %3d", H[i][j]);
            }
            System.out.println();
        }
    }

    private static int min(int ... nums) {
        int min = Integer.MAX_VALUE;
        for (int num : nums) {
            min = Math.min(min, num);
        }
        return min;
    }

    public float matchProb() {
        if (this.type == EditDistanceStringMatchingStrategy.Type.SemiGlobal) {
            return 1.0f - (float)this.distance() / (float)this.searchTerm.length();
        }
        return 1.0f - (float)this.distance() / (float)Math.min(this.searchTerm.length(), this.searchText.length());
    }

    public void init(String searchTerm, String searchText, boolean subStringMatch, boolean caseSensitive) {
        int i;
        if (searchTerm == null || searchText == null) {
            throw new IllegalArgumentException("Null searchText/searchTerm!");
        }
        if (caseSensitive) {
            this.searchTerm = searchTerm;
            this.searchText = searchText;
        } else {
            this.searchTerm = searchTerm.toLowerCase();
            this.searchText = searchText.toLowerCase();
        }
        this.type = subStringMatch ? EditDistanceStringMatchingStrategy.Type.SemiGlobal : EditDistanceStringMatchingStrategy.Type.Global;
        int maxCodePoint = 0;
        for (i = 0; i < this.searchTerm.length(); ++i) {
            maxCodePoint = Math.max(maxCodePoint, this.searchTerm.charAt(i));
        }
        for (i = 0; i < this.searchText.length(); ++i) {
            maxCodePoint = Math.max(maxCodePoint, this.searchText.charAt(i));
        }
        this.alphabetLength = maxCodePoint + 1;
    }

    public boolean matches(String searchTerm, String searchText, boolean subStringMatch, boolean caseSensitive) {
        this.init(searchTerm, searchText, subStringMatch, caseSensitive);
        return (double)this.matchProb() > StringMatchingStrategy.APPROXIMATE_MATCHING_MINPROB;
    }
}

