/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.encrypt.EnterPassword;
import org.freeplane.features.encrypt.PasswordStrategy;
import org.freeplane.features.encrypt.SingleDesEncrypter;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class EncryptionController
implements IExtension {
    private static final IconStore STORE = IconStoreFactory.create();
    private static UIIcon decryptedIcon = STORE.getUIIcon("unlock.png");
    private static UIIcon encryptedIcon = STORE.getUIIcon("lock.png");

    public static void install(EncryptionController encryptionController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(EncryptionController.class, encryptionController);
        EnterPassword pwdAction = new EnterPassword(encryptionController);
        modeController.addAction(pwdAction);
    }

    public EncryptionController(ModeController modeController) {
        this.registerStateIconProvider(modeController);
    }

    private void registerStateIconProvider(ModeController modeController) {
        IconController.getController(modeController).addStateIconProvider(new IStateIconProvider(){

            public UIIcon getStateIcon(NodeModel node) {
                EncryptionModel encryptionModel = EncryptionModel.getModel(node);
                if (encryptionModel != null) {
                    if (encryptionModel.isAccessible()) {
                        return decryptedIcon;
                    }
                    return encryptedIcon;
                }
                return null;
            }
        });
    }

    public void toggleCryptState(final NodeModel node, PasswordStrategy passwordStrategy) {
        final EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        if (encryptionModel != null) {
            final boolean wasAccessible = encryptionModel.isAccessible();
            final boolean wasFolded = node.isFolded();
            if (wasAccessible) {
                encryptionModel.setAccessible(false);
                encryptionModel.getEncryptedContent(Controller.getCurrentModeController().getMapController());
                node.setFolded(true);
            } else if (this.doPasswordCheckAndDecryptNode(encryptionModel, passwordStrategy)) {
                node.setFolded(false);
            } else {
                return;
            }
            Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(node);
            IActor actor = new IActor(){

                public void act() {
                    encryptionModel.setAccessible(!wasAccessible);
                    if (wasAccessible) {
                        node.setFolded(true);
                    }
                    Controller.getCurrentModeController().getMapController().nodeRefresh(node);
                }

                public String getDescription() {
                    return "toggleCryptState";
                }

                public void undo() {
                    encryptionModel.setAccessible(wasAccessible);
                    if (wasAccessible) {
                        node.setFolded(wasFolded);
                    }
                    Controller.getCurrentModeController().getMapController().nodeRefresh(node);
                }
            };
            Controller.getCurrentModeController().execute(actor, node.getMap());
        } else {
            this.encrypt(node, passwordStrategy);
        }
    }

    private boolean doPasswordCheckAndDecryptNode(EncryptionModel encryptionModel, PasswordStrategy passwordStrategy) {
        StringBuilder password = passwordStrategy.getPassword();
        if (passwordStrategy.isCancelled()) {
            return false;
        }
        if (!this.decrypt(encryptionModel, password)) {
            passwordStrategy.onWrongPassword();
            return false;
        }
        return true;
    }

    private boolean decrypt(EncryptionModel encryptionModel, StringBuilder password) {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        return encryptionModel.decrypt(mapController, new SingleDesEncrypter(password));
    }

    private void encrypt(final NodeModel node, PasswordStrategy passwordStrategy) {
        StringBuilder password = passwordStrategy.getPasswordWithConfirmation();
        if (passwordStrategy.isCancelled()) {
            return;
        }
        final EncryptionModel encryptionModel = new EncryptionModel(node);
        encryptionModel.setEncrypter(new SingleDesEncrypter(password));
        IActor actor = new IActor(){

            public void act() {
                node.addExtension(encryptionModel);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "encrypt";
            }

            public void undo() {
                node.removeExtension(encryptionModel);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }
}

