/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.encrypt.Base64Coding;
import org.freeplane.features.map.IEncrypter;

public class DesEncrypter
implements IEncrypter {
    private static final int SALT_LENGTH = 8;
    private static final String SALT_PRESENT_INDICATOR = " ";
    private Cipher dcipher;
    private Cipher ecipher;
    int iterationCount = 19;
    private final String mAlgorithm;
    byte[] mSalt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    private char[] passPhrase;

    public static byte[] fromBase64(String base64String) {
        return Base64Coding.decode64(base64String);
    }

    public static String toBase64(byte[] byteBuffer) {
        return Base64Coding.encode64(byteBuffer);
    }

    public DesEncrypter(StringBuilder pPassPhrase, String pAlgorithm) {
        this.passPhrase = new char[pPassPhrase.length()];
        pPassPhrase.getChars(0, this.passPhrase.length, this.passPhrase, 0);
        this.mAlgorithm = pAlgorithm;
    }

    public String decrypt(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] salt = null;
            int indexOfSaltIndicator = str.indexOf(SALT_PRESENT_INDICATOR);
            if (indexOfSaltIndicator >= 0) {
                String saltString = str.substring(0, indexOfSaltIndicator);
                str = str.substring(indexOfSaltIndicator + 1);
                salt = DesEncrypter.fromBase64(saltString);
            }
            byte[] dec = DesEncrypter.fromBase64(str);
            this.init(salt);
            if (this.dcipher == null) {
                return null;
            }
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (BadPaddingException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public String encrypt(String str) {
        try {
            this.initWithNewSalt();
            if (this.ecipher == null) {
                return null;
            }
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return DesEncrypter.toBase64(this.mSalt) + SALT_PRESENT_INDICATOR + DesEncrypter.toBase64(enc);
        }
        catch (BadPaddingException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public void initWithNewSalt() {
        byte[] newSalt = new byte[8];
        for (int i = 0; i < newSalt.length; ++i) {
            newSalt[i] = (byte)(Math.random() * 256.0 - 128.0);
        }
        this.init(newSalt);
    }

    private void init(byte[] salt) {
        if (this.ecipher != null && this.mSalt != null && !Arrays.equals(this.mSalt, salt)) {
            this.ecipher = null;
            this.dcipher = null;
        }
        if (salt != null) {
            this.mSalt = salt;
        }
        if (this.ecipher == null) {
            try {
                SecretKey key;
                try {
                    PBEKeySpec keySpec = new PBEKeySpec(this.passPhrase, this.mSalt, this.iterationCount);
                    key = SecretKeyFactory.getInstance(this.mAlgorithm).generateSecret(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    try {
                        this.passPhrase = URLEncoder.encode(new String(this.passPhrase), "UTF-8").toCharArray();
                    }
                    catch (UnsupportedEncodingException e1) {
                        throw e;
                    }
                    PBEKeySpec keySpec = new PBEKeySpec(this.passPhrase, this.mSalt, this.iterationCount);
                    key = SecretKeyFactory.getInstance(this.mAlgorithm).generateSecret(keySpec);
                }
                this.ecipher = Cipher.getInstance(this.mAlgorithm);
                this.dcipher = Cipher.getInstance(this.mAlgorithm);
                PBEParameterSpec paramSpec = new PBEParameterSpec(this.mSalt, this.iterationCount);
                this.ecipher.init(1, (Key)key, paramSpec);
                this.dcipher.init(2, (Key)key, paramSpec);
            }
            catch (InvalidAlgorithmParameterException e) {
                LogUtils.severe(e);
            }
            catch (InvalidKeySpecException e) {
                LogUtils.severe(e);
            }
            catch (NoSuchPaddingException e) {
                LogUtils.severe(e);
            }
            catch (NoSuchAlgorithmException e) {
                LogUtils.severe(e);
            }
            catch (InvalidKeyException e) {
                LogUtils.severe(e);
            }
        }
    }
}

