/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge;

import org.freeplane.core.util.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EdgeStyle {
    EDGESTYLE_BEZIER("bezier", 1.0f),
    EDGESTYLE_HIDDEN("hide_edge", 1.0f),
    EDGESTYLE_HORIZONTAL("horizontal", 1.0f),
    EDGESTYLE_LINEAR("linear", 1.0f),
    EDGESTYLE_SHARP_BEZIER("sharp_bezier", 0.25f),
    EDGESTYLE_SHARP_LINEAR("sharp_linear", 0.0f),
    EDGESTYLE_SUMMARY("summary", 1.0f);

    private String name;
    private float nodeLineWeight;

    private EdgeStyle(String name, float nodeLineWeight) {
        this.name = name;
        this.nodeLineWeight = nodeLineWeight;
    }

    public String toString() {
        return this.name;
    }

    public int getNodeLineWidth(int width) {
        int nlWidth = (int)(this.nodeLineWeight * (float)width);
        if (nlWidth == 0) {
            return 1;
        }
        return nlWidth;
    }

    public static EdgeStyle getStyle(String name) {
        if (name == null) {
            return null;
        }
        for (EdgeStyle style : (EdgeStyle[])EdgeStyle.class.getEnumConstants()) {
            if (!style.name.equals(name)) continue;
            return style;
        }
        LogUtils.warn("unknown edge style name " + name);
        return null;
    }

    public static String toString(EdgeStyle style) {
        return style == null ? null : style.toString();
    }
}

