/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge;

import java.awt.Color;
import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.edge.EdgeBuilder;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeController
implements IExtension {
    public static final EdgeStyle STANDARD_EDGE_STYLE = EdgeStyle.EDGESTYLE_BEZIER;
    public static final Color STANDARD_EDGE_COLOR = Color.GRAY;
    private final ExclusivePropertyChain<Color, NodeModel> colorHandlers = new ExclusivePropertyChain();
    private final ExclusivePropertyChain<EdgeStyle, NodeModel> styleHandlers = new ExclusivePropertyChain();
    private final ExclusivePropertyChain<Integer, NodeModel> widthHandlers = new ExclusivePropertyChain();

    public static EdgeController getController() {
        return EdgeController.getController(Controller.getCurrentModeController());
    }

    public static EdgeController getController(ModeController modeController) {
        return modeController.getExtension(EdgeController.class);
    }

    public static void install(EdgeController edgeController) {
        Controller.getCurrentModeController().addExtension(EdgeController.class, edgeController);
    }

    public EdgeController(final ModeController modeController) {
        this.addColorGetter(IPropertyHandler.STYLE, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, Color currentValue) {
                return EdgeController.this.getStyleEdgeColor(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        this.addColorGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, Color currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return STANDARD_EDGE_COLOR;
            }
        });
        this.addStyleGetter(IPropertyHandler.STYLE, new IPropertyHandler<EdgeStyle, NodeModel>(){

            @Override
            public EdgeStyle getProperty(NodeModel node, EdgeStyle currentValu) {
                return EdgeController.this.getStyleStyle(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        this.addStyleGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<EdgeStyle, NodeModel>(){

            @Override
            public EdgeStyle getProperty(NodeModel node, EdgeStyle currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return STANDARD_EDGE_STYLE;
            }
        });
        this.addWidthGetter(IPropertyHandler.STYLE, new IPropertyHandler<Integer, NodeModel>(){

            @Override
            public Integer getProperty(NodeModel node, Integer currentValue) {
                return EdgeController.this.getStyleWidth(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        this.addWidthGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Integer, NodeModel>(){

            @Override
            public Integer getProperty(NodeModel node, Integer currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return new Integer(0);
            }
        });
        MapController mapController = Controller.getCurrentModeController().getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        EdgeBuilder edgeBuilder = new EdgeBuilder(this);
        edgeBuilder.registerBy(readManager, writeManager);
    }

    public IPropertyHandler<Color, NodeModel> addColorGetter(Integer key, IPropertyHandler<Color, NodeModel> getter) {
        return this.colorHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<EdgeStyle, NodeModel> addStyleGetter(Integer key, IPropertyHandler<EdgeStyle, NodeModel> getter) {
        return this.styleHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Integer, NodeModel> addWidthGetter(Integer key, IPropertyHandler<Integer, NodeModel> getter) {
        return this.widthHandlers.addGetter(key, getter);
    }

    public Color getColor(NodeModel node) {
        return this.getColor(node, true);
    }

    public Color getColor(NodeModel node, boolean resolveParent) {
        Color color = this.colorHandlers.getProperty(node);
        if (color == null && resolveParent) {
            return this.getColor(node.getParentNode());
        }
        return color;
    }

    public EdgeStyle getStyle(NodeModel node) {
        return this.getStyle(node, true);
    }

    public EdgeStyle getStyle(NodeModel node, boolean resolveParent) {
        EdgeStyle style = this.styleHandlers.getProperty(node);
        if (style == null && resolveParent) {
            return this.getStyle(node.getParentNode());
        }
        return style;
    }

    public int getWidth(NodeModel node) {
        return this.getWidth(node, true);
    }

    public Integer getWidth(NodeModel node, boolean resolveParent) {
        Integer width = this.widthHandlers.getProperty(node);
        if (width == null && resolveParent) {
            return this.getWidth(node.getParentNode());
        }
        return width;
    }

    public IPropertyHandler<Color, NodeModel> removeColorGetter(Integer key) {
        return this.colorHandlers.removeGetter(key);
    }

    public IPropertyHandler<EdgeStyle, NodeModel> removeStyleGetter(Integer key) {
        return this.styleHandlers.removeGetter(key);
    }

    public IPropertyHandler<Integer, NodeModel> removeWidthGetter(Integer key) {
        return this.widthHandlers.removeGetter(key);
    }

    private Color getStyleEdgeColor(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            Color styleColor;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (styleColor = styleModel.getColor()) == null) continue;
            return styleColor;
        }
        return null;
    }

    private Integer getStyleWidth(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            int width;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (width = styleModel.getWidth()) == -1) continue;
            return width;
        }
        return null;
    }

    private EdgeStyle getStyleStyle(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            EdgeStyle style;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (style = styleModel.getStyle()) == null) continue;
            return style;
        }
        return null;
    }
}

