/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge;

import java.awt.Color;
import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

class EdgeBuilder
implements IElementDOMHandler,
IExtensionElementWriter,
IElementWriter {
    private final EdgeController ec;

    public EdgeBuilder(EdgeController ec) {
        this.ec = ec;
    }

    protected EdgeModel createEdge(NodeModel node) {
        return EdgeModel.createEdgeModel(node);
    }

    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals("edge")) {
            return this.createEdge((NodeModel)parent);
        }
        return null;
    }

    public void endElement(Object parent, String tag, Object userObject, XMLElement dom) {
        if (parent instanceof NodeModel) {
            NodeModel node = (NodeModel)parent;
            if (userObject instanceof EdgeModel) {
                EdgeModel edge = (EdgeModel)userObject;
                EdgeModel.setModel(node, edge);
            }
            return;
        }
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("edge", "STYLE", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                EdgeModel edge = (EdgeModel)userObject;
                edge.setStyle(EdgeStyle.getStyle(value));
            }
        });
        reader.addAttributeHandler("edge", "HIDE", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                EdgeModel edge = (EdgeModel)userObject;
                edge.setStyle(EdgeStyle.EDGESTYLE_HIDDEN);
            }
        });
        reader.addAttributeHandler("edge", "COLOR", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                EdgeModel edge = (EdgeModel)userObject;
                edge.setColor(ColorUtils.stringToColor(value.toString()));
            }
        });
        reader.addAttributeHandler("edge", "WIDTH", new IAttributeHandler(){

            public void setAttribute(Object userObject, String value) {
                EdgeModel edge = (EdgeModel)userObject;
                if (value.equals("thin")) {
                    edge.setWidth(0);
                } else {
                    edge.setWidth(Integer.parseInt(value.toString()));
                }
            }
        });
    }

    public void registerBy(ReadManager reader, WriteManager writer) {
        reader.addElementHandler("edge", this);
        this.registerAttributeHandlers(reader);
        writer.addExtensionElementWriter(EdgeModel.class, this);
        writer.addElementWriter("node", this);
        writer.addElementWriter("stylenode", this);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    public void writeContent(ITreeWriter writer, Object element, String tag) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (!forceFormatting) {
            return;
        }
        NodeModel node = (NodeModel)element;
        this.writeContent(writer, node, null, forceFormatting);
    }

    public void writeContent(ITreeWriter writer, Object userObject, IExtension extension) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            return;
        }
        EdgeModel model = (EdgeModel)extension;
        this.writeContent(writer, null, model, forceFormatting);
    }

    private void writeContent(ITreeWriter writer, NodeModel node, EdgeModel model, boolean forceFormatting) throws IOException {
        int width;
        EdgeStyle styleObj = forceFormatting ? this.ec.getStyle(node) : model.getStyle();
        String style = EdgeStyle.toString(styleObj);
        Color color = forceFormatting ? this.ec.getColor(node) : model.getColor();
        int n = width = forceFormatting ? this.ec.getWidth(node) : model.getWidth();
        if (forceFormatting || style != null || color != null || width != -1) {
            XMLElement edge = new XMLElement();
            edge.setName("edge");
            boolean relevant = false;
            if (style != null) {
                if (style.equals((Object)EdgeStyle.EDGESTYLE_HIDDEN)) {
                    edge.setAttribute("HIDE", "true");
                    relevant = true;
                }
                edge.setAttribute("STYLE", style);
                relevant = true;
            }
            if (color != null) {
                edge.setAttribute("COLOR", ColorUtils.colorToString(color));
                relevant = true;
            }
            if (width != -1) {
                if (width == 0) {
                    edge.setAttribute("WIDTH", "thin");
                } else {
                    edge.setAttribute("WIDTH", Integer.toString(width));
                }
                relevant = true;
            }
            if (relevant) {
                writer.addElement((Object)model, edge);
            }
        }
    }
}

