/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.cloud;

import java.awt.Color;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.map.NodeModel;

public class CloudModel
implements IExtension {
    private Color color = CloudController.getStandardColor();
    private Shape shape = Shape.ARC;

    public static CloudModel getModel(NodeModel node) {
        return node.getExtension(CloudModel.class);
    }

    public static CloudModel createModel(NodeModel node) {
        CloudModel extension = node.getExtension(CloudModel.class);
        if (extension != null) {
            return extension;
        }
        CloudModel cloudModel = new CloudModel();
        node.addExtension(cloudModel);
        return cloudModel;
    }

    public static void setModel(NodeModel node, CloudModel cloud) {
        CloudModel oldCloud = CloudModel.getModel(node);
        if (cloud != null && oldCloud == null) {
            node.addExtension(cloud);
        } else if (cloud == null && oldCloud != null) {
            node.removeExtension(CloudModel.class);
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color != null ? color : CloudController.getStandardColor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Shape {
        ARC,
        STAR,
        RECT,
        ROUND_RECT;

    }
}

