/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.freeplane.core.util.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapNodesSelection
implements Transferable,
ClipboardOwner {
    public static DataFlavor dropActionFlavor = null;
    public static DataFlavor fileListFlavor = null;
    public static DataFlavor htmlFlavor = null;
    public static DataFlavor mindMapNodesFlavor = null;
    public static DataFlavor rtfFlavor = null;
    private String dropActionContent;
    private final List<?> fileList;
    private final String htmlContent;
    private final String nodesContent;
    private final String rtfContent;
    private final String stringContent;

    public MindMapNodesSelection(String nodesContent, String stringContent, String rtfContent, String htmlContent, String dropActionContent, List<?> fileList) {
        this.nodesContent = nodesContent;
        this.rtfContent = rtfContent;
        this.stringContent = stringContent;
        this.dropActionContent = dropActionContent;
        this.htmlContent = htmlContent;
        this.fileList = fileList;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.stringContent;
        }
        if (flavor.equals(mindMapNodesFlavor)) {
            return this.nodesContent;
        }
        if (flavor.equals(dropActionFlavor)) {
            return this.dropActionContent;
        }
        if (flavor.equals(rtfFlavor)) {
            byte[] byteArray = this.rtfContent.getBytes();
            return new ByteArrayInputStream(byteArray);
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return this.htmlContent;
        }
        if (flavor.equals(fileListFlavor)) {
            return this.fileList;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.stringFlavor, mindMapNodesFlavor, rtfFlavor, htmlFlavor, dropActionFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(DataFlavor.stringFlavor) && this.stringContent != null) {
            return true;
        }
        if (flavor.equals(mindMapNodesFlavor) && this.nodesContent != null) {
            return true;
        }
        if (flavor.equals(rtfFlavor) && this.rtfContent != null) {
            return true;
        }
        if (flavor.equals(dropActionFlavor) && this.dropActionContent != null) {
            return true;
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return true;
        }
        return flavor.equals(fileListFlavor) && this.fileList != null && this.fileList.size() > 0;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setDropAction(String dropActionContent) {
        this.dropActionContent = dropActionContent;
    }

    static {
        try {
            mindMapNodesFlavor = new DataFlavor("text/freeplane-nodes; class=java.lang.String");
            rtfFlavor = new DataFlavor("text/rtf; class=java.io.InputStream");
            htmlFlavor = new DataFlavor("text/html; class=java.lang.String");
            fileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List");
            dropActionFlavor = new DataFlavor("text/drop-action; class=java.lang.String");
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }
}

