/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard;

import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.FreeplaneUriConverter;

public class CopyNodeURIAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public CopyNodeURIAction() {
        super("CopyNodeURIAction");
    }

    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        NodeModel node = controller.getSelection().getSelected();
        File mindmapFile = node.getMap().getFile();
        if (mindmapFile == null) {
            UITools.errorMessage(TextUtils.getRawText("map_not_saved"));
            return;
        }
        String idString = this.uri(node, mindmapFile);
        ClipboardController clipboardController = Controller.getCurrentModeController().getExtension(ClipboardController.class);
        clipboardController.setClipboardContents(new StringSelection(idString));
        controller.getViewController().out(idString);
    }

    public String uri(NodeModel node, File mindmapFile) {
        String fileBasedUri = mindmapFile.toURI().toString() + '#' + node.createID();
        FreeplaneUriConverter freeplaneUriConverter = new FreeplaneUriConverter();
        return freeplaneUriConverter.freeplaneUriForFile(fileBasedUri);
    }
}

