/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.clipboard.CopyAction;
import org.freeplane.features.clipboard.CopyIDAction;
import org.freeplane.features.clipboard.CopyNodeURIAction;
import org.freeplane.features.clipboard.CopySingleAction;
import org.freeplane.features.clipboard.MindMapHTMLWriter;
import org.freeplane.features.clipboard.MindMapNodesSelection;
import org.freeplane.features.clipboard.SingleCopySource;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.text.TextController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipboardController
implements IExtension {
    public static final String NODESEPARATOR = "<nodeseparator>";
    private final Clipboard clipboard;
    private final Clipboard selection;

    public static ClipboardController getController() {
        return Controller.getCurrentModeController().getExtension(ClipboardController.class);
    }

    public static void install(ClipboardController clipboardController) {
        Controller.getCurrentModeController().addExtension(ClipboardController.class, clipboardController);
    }

    public ClipboardController() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.selection = toolkit.getSystemSelection();
        this.clipboard = toolkit.getSystemClipboard();
        this.createActions();
    }

    private void collectColors(NodeModel node, HashSet<Color> colors) {
        Color color = NodeStyleModel.getColor(node);
        if (color != null) {
            colors.add(color);
        }
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            this.collectColors(child, colors);
        }
    }

    public Transferable copy(Collection<NodeModel> selectedNodes, boolean copyInvisible) {
        try {
            String forNodesFlavor = this.createForNodesFlavor(selectedNodes, copyInvisible);
            String plainText = this.getAsPlainText(selectedNodes);
            return new MindMapNodesSelection(forNodesFlavor, plainText, this.getAsRTF(selectedNodes), this.getAsHTML(selectedNodes), null, null);
        }
        catch (UnsupportedFlavorException ex) {
            LogUtils.severe(ex);
        }
        catch (IOException ex) {
            LogUtils.severe(ex);
        }
        return null;
    }

    public Transferable copy(IMapSelection selection) {
        return this.copy(selection.getSortedSelection(true), false);
    }

    public Transferable copy(NodeModel node, boolean saveInvisible) {
        StringWriter stringWriter = new StringWriter();
        try {
            Controller.getCurrentModeController().getMapController().getMapWriter().writeNodeAsXml(stringWriter, node, MapWriter.Mode.CLIPBOARD, saveInvisible, true, false);
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
        return new MindMapNodesSelection(stringWriter.toString(), null, null, null, null, null);
    }

    public Transferable copySingle(Collection<NodeModel> source) {
        int size = source.size();
        Vector<NodeModel> target = new Vector<NodeModel>(size);
        target.setSize(size);
        int i = 0;
        for (NodeModel node : source) {
            target.set(i, new SingleCopySource(node));
            ++i;
        }
        return this.copy(target, false);
    }

    private void createActions() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        modeController.addAction(new CopyAction());
        modeController.addAction(new CopySingleAction());
        modeController.addAction(new CopyIDAction());
        modeController.addAction(new CopyNodeURIAction());
    }

    public String createForNodesFlavor(Collection<NodeModel> selectedNodes, boolean copyInvisible) throws UnsupportedFlavorException, IOException {
        String forNodesFlavor = "";
        boolean firstLoop = true;
        for (NodeModel tmpNode : selectedNodes) {
            if (firstLoop) {
                firstLoop = false;
            } else {
                forNodesFlavor = forNodesFlavor + NODESEPARATOR;
            }
            forNodesFlavor = forNodesFlavor + this.copy(tmpNode, copyInvisible).getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
        }
        return forNodesFlavor;
    }

    public String getAsHTML(Collection<NodeModel> selectedNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            this.writeHTML(selectedNodes, fileout);
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public String getAsPlainText(Collection<NodeModel> selectedNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            Iterator<NodeModel> it = selectedNodes.iterator();
            while (it.hasNext()) {
                this.writeTXT(it.next(), fileout, 0);
            }
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public String getAsRTF(Collection<NodeModel> selectedNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            this.writeRTF(selectedNodes, fileout);
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public Transferable getClipboardContents() {
        return this.clipboard.getContents(this);
    }

    private String rtfEscapeUnicodeAndSpecialCharacters(String text) {
        int len = text.length();
        StringBuilder result = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue > '\u0080') {
                result.append("\\u").append((int)intValue).append("?");
                continue;
            }
            switch (myChar) {
                case '\\': {
                    result.append("\\\\");
                    continue block6;
                }
                case '{': {
                    result.append("\\{");
                    continue block6;
                }
                case '}': {
                    result.append("\\}");
                    continue block6;
                }
                case '\n': {
                    result.append(" \\line ");
                    continue block6;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        return result.toString();
    }

    public void saveHTML(NodeModel rootNodeOfBranch, File file) throws IOException {
        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(Controller.getCurrentModeController().getMapController(), fileout);
        htmlWriter.writeHTML(rootNodeOfBranch);
    }

    public boolean saveTXT(NodeModel rootNodeOfBranch, File file) {
        try {
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            this.writeTXT(rootNodeOfBranch, fileout, 0);
            fileout.close();
            return true;
        }
        catch (Exception e) {
            LogUtils.severe("Error in MindMapMapModel.saveTXT(): ", e);
            return false;
        }
    }

    public void setClipboardContents(Transferable t) {
        this.clipboard.setContents(t, null);
        if (this.selection != null) {
            this.selection.setContents(t, null);
        }
    }

    public void setClipboardContents(String string) {
        this.setClipboardContents(new StringSelection(string));
    }

    public NodeModel duplicate(NodeModel source, boolean withChildren) {
        try {
            StringWriter writer = new StringWriter();
            ModeController modeController = Controller.getCurrentModeController();
            modeController.getMapController().getMapWriter().writeNodeAsXml(writer, source, MapWriter.Mode.CLIPBOARD, true, withChildren, false);
            String result = writer.toString();
            NodeModel copy = modeController.getMapController().getMapReader().createNodeTreeFromXml(source.getMap(), (Reader)new StringReader(result), MapWriter.Mode.CLIPBOARD);
            copy.setFolded(false);
            return copy;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    private void writeChildrenRTF(NodeModel node, Writer fileout, int depth, HashMap<Color, Integer> colorTable) throws IOException {
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            if (child.isVisible()) {
                this.writeRTF(child, fileout, depth + 1, colorTable);
                continue;
            }
            this.writeChildrenRTF(child, fileout, depth, colorTable);
        }
    }

    private void writeChildrenText(NodeModel node, Writer fileout, int depth) throws IOException {
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            if (child.isVisible()) {
                this.writeTXT(child, fileout, depth + 1);
                continue;
            }
            this.writeChildrenText(child, fileout, depth);
        }
    }

    public void writeHTML(Collection<NodeModel> selectedNodes, Writer fileout) throws IOException {
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(Controller.getCurrentModeController().getMapController(), fileout);
        htmlWriter.writeHTML(selectedNodes);
    }

    public boolean writeRTF(Collection<NodeModel> selectedNodes, BufferedWriter fileout) {
        try {
            HashSet<Color> colors = new HashSet<Color>();
            Iterator<NodeModel> it = selectedNodes.iterator();
            while (it.hasNext()) {
                this.collectColors(it.next(), colors);
            }
            String colorTableString = "{\\colortbl;\\red0\\green0\\blue255;";
            HashMap<Color, Integer> colorTable = new HashMap<Color, Integer>();
            int colorPosition = 2;
            for (Color color : colors) {
                colorTableString = colorTableString + "\\red" + color.getRed() + "\\green" + color.getGreen() + "\\blue" + color.getBlue() + ";";
                colorTable.put(color, new Integer(colorPosition));
            }
            colorTableString = colorTableString + "}";
            fileout.write("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1033{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}" + colorTableString + "}" + "\\viewkind4\\uc1\\pard\\f0\\fs20{}");
            Iterator<NodeModel> it2 = selectedNodes.iterator();
            while (it2.hasNext()) {
                this.writeRTF(it2.next(), fileout, 0, colorTable);
            }
            fileout.write("}");
            return true;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return false;
        }
    }

    public void writeRTF(NodeModel mindMapNodeModel, Writer fileout, int depth, HashMap<Color, Integer> colorTable) throws IOException {
        NodeStyleModel font;
        String pre = "{\\li" + depth * 350;
        String level = depth <= 8 ? "\\outlinelevel" + depth : "";
        String fontsize = "";
        if (NodeStyleModel.getColor(mindMapNodeModel) != null) {
            pre = pre + "\\cf" + colorTable.get(NodeStyleModel.getColor(mindMapNodeModel));
        }
        if ((font = NodeStyleModel.getModel(mindMapNodeModel)) != null) {
            if (Boolean.TRUE.equals(font.isItalic())) {
                pre = pre + "\\i ";
            }
            if (Boolean.TRUE.equals(font.isBold())) {
                pre = pre + "\\b ";
            }
            if (font.getFontSize() != null) {
                fontsize = "\\fs" + Math.round(1.5 * (double)font.getFontSize().intValue());
                pre = pre + fontsize;
            }
        }
        pre = pre + "{}";
        fileout.write("\\li" + depth * 350 + level + "{}");
        String nodeText = TextController.getController().getPlainTextContent(mindMapNodeModel);
        if (nodeText.matches(" *")) {
            fileout.write("o");
        } else {
            String text = this.rtfEscapeUnicodeAndSpecialCharacters(nodeText);
            if (NodeLinks.getValidLink(mindMapNodeModel) != null) {
                String link = this.rtfEscapeUnicodeAndSpecialCharacters(NodeLinks.getLinkAsString(mindMapNodeModel));
                if (link.equals(nodeText)) {
                    fileout.write(pre + "<{\\ul\\cf1 " + link + "}>" + "}");
                } else {
                    fileout.write("{" + fontsize + pre + text + "} ");
                    fileout.write("<{\\ul\\cf1 " + link + "}}>");
                }
            } else {
                fileout.write(pre + text + "}");
            }
        }
        fileout.write("\\par");
        fileout.write("\n");
        this.writeChildrenRTF(mindMapNodeModel, fileout, depth, colorTable);
    }

    public void writeTXT(NodeModel mindMapNodeModel, Writer fileout, int depth) throws IOException {
        String plainTextContent = TextController.getController().getPlainTextContent(mindMapNodeModel).replace('\n', ' ');
        for (int i = 0; i < depth; ++i) {
            fileout.write("    ");
        }
        if (plainTextContent.matches(" *")) {
            fileout.write("o");
        } else if (NodeLinks.getValidLink(mindMapNodeModel) != null) {
            String link = NodeLinks.getLinkAsString(mindMapNodeModel);
            if (!link.equals(plainTextContent)) {
                fileout.write(plainTextContent + " ");
            }
            fileout.write("<" + link + ">");
        } else {
            fileout.write(plainTextContent);
        }
        fileout.write("\n");
        this.writeChildrenText(mindMapNodeModel, fileout, depth);
    }
}

