/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeTableLayoutModel;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.map.NodeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeAttributeTableModel
implements IExtension,
IAttributeTableModel,
TableModel {
    private static final int CAPACITY_INCREMENT = 10;
    public static final NodeAttributeTableModel EMTPY_ATTRIBUTES = new NodeAttributeTableModel(null);
    private Vector<Attribute> attributes;
    private AttributeTableLayoutModel layout;
    private HashSet<TableModelListener> listeners;
    private final NodeModel node;

    public static NodeAttributeTableModel getModel(NodeModel node) {
        NodeAttributeTableModel attributes = node.getExtension(NodeAttributeTableModel.class);
        return attributes != null ? attributes : EMTPY_ATTRIBUTES;
    }

    public NodeAttributeTableModel(NodeModel node) {
        this(node, 0);
    }

    public NodeAttributeTableModel(NodeModel node, int size) {
        this.allocateAttributes(size);
        this.node = node;
    }

    public void addRowNoUndo(Attribute newAttribute) {
        this.allocateAttributes(10);
        int index = this.getRowCount();
        AttributeRegistry registry = AttributeRegistry.getRegistry(this.node.getMap());
        registry.registry(newAttribute);
        this.attributes.add(newAttribute);
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    private void allocateAttributes(int size) {
        if (this.attributes == null && size > 0) {
            this.attributes = new Vector(size, 10);
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        if (this.listeners == null) {
            return;
        }
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    private void fireTableChanged(TableModelEvent e) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<TableModelListener> arrayList = new ArrayList<TableModelListener>(this.listeners);
        for (TableModelListener listener : arrayList) {
            listener.tableChanged(e);
        }
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        if (this.listeners == null) {
            return;
        }
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        if (this.listeners == null) {
            return;
        }
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        if (this.listeners == null) {
            return;
        }
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public Attribute getAttribute(int row) {
        return this.attributes.get(row);
    }

    public List<String> getAttributeKeyList() {
        Vector<String> returnValue = new Vector<String>();
        for (Attribute attr : this.getAttributes()) {
            returnValue.add(attr.getName());
        }
        return returnValue;
    }

    public int getAttributePosition(String pKey) {
        if (pKey == null) {
            return -1;
        }
        int pos = 0;
        for (Attribute attr : this.getAttributes()) {
            if (pKey.equals(attr.getName())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public Vector<Attribute> getAttributes() {
        this.allocateAttributes(10);
        return this.attributes;
    }

    public int getAttributeTableLength() {
        return this.getRowCount();
    }

    public Class<Object> getColumnClass(int col) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        return " ";
    }

    @Override
    public int getColumnWidth(int col) {
        return this.getLayout().getColumnWidth(col);
    }

    public AttributeTableLayoutModel getLayout() {
        if (this.layout == null) {
            this.layout = new AttributeTableLayoutModel();
        }
        return this.layout;
    }

    public Object getName(int row) {
        Attribute attr = this.attributes.get(row);
        return attr.getName();
    }

    @Override
    public NodeModel getNode() {
        return this.node;
    }

    @Override
    public int getRowCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Object getValue(int row) {
        Attribute attr = this.attributes.get(row);
        return attr.getValue();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.attributes != null) {
            switch (col) {
                case 0: {
                    return this.getName(row);
                }
                case 1: {
                    return this.getValue(row);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void setName(int row, Object newName) {
        Attribute attr = this.attributes.get(row);
        attr.setName(newName.toString());
        this.fireTableRowsUpdated(row, row);
    }

    public void setValue(int row, Object newValue) {
        Attribute attr = this.attributes.get(row);
        attr.setValue(newValue);
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.setName(rowIndex, value);
                return;
            }
            case 1: {
                this.setValue(rowIndex, value);
                return;
            }
        }
        throw new ArrayIndexOutOfBoundsException(columnIndex + " >= 2");
    }
}

