/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import javax.swing.table.AbstractTableModel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.IListModel;
import org.freeplane.features.attribute.AttributeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeRegistryTableModel
extends AbstractTableModel {
    private static String attributeColumnName = null;
    private static String editorColumnName = null;
    private static String restrictionColumnName = null;
    private static final long serialVersionUID = 1L;
    private static String visibilityColumnName = null;
    private final String allAttributes = TextUtils.getText("attributes_all");
    private final AttributeRegistry attributeRegistry;

    AttributeRegistryTableModel(AttributeRegistry registry) {
        this.attributeRegistry = registry;
    }

    public void fireRestrictionsUpdated(int row) {
        this.fireTableRowsUpdated(row + 1, row + 1);
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        super.fireTableCellUpdated(row + 1, column);
    }

    public void fireTableRowsDeleted() {
        if (this.getRowCount() > 1) {
            this.fireTableRowsDeleted(1, this.getRowCount() - 1);
        }
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        super.fireTableRowsDeleted(firstRow + 1, lastRow + 1);
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        super.fireTableRowsInserted(firstRow + 1, lastRow + 1);
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        super.fireTableRowsUpdated(firstRow + 1, lastRow + 1);
    }

    public void fireVisibilityUpdated(int row) {
        this.fireTableCellUpdated(row + 1, 1);
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return IListModel.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if (attributeColumnName == null) {
                    attributeColumnName = TextUtils.getText("attributes_attribute");
                }
                return attributeColumnName;
            }
            case 1: {
                if (visibilityColumnName == null) {
                    visibilityColumnName = TextUtils.getText("attributes_visible");
                }
                return visibilityColumnName;
            }
            case 2: {
                if (restrictionColumnName == null) {
                    restrictionColumnName = TextUtils.getText("attributes_restriction");
                }
                return restrictionColumnName;
            }
            case 3: {
                if (editorColumnName == null) {
                    editorColumnName = TextUtils.getText("attributes_edit");
                }
                return editorColumnName;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.attributeRegistry.size() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col < 2) {
            if (col == 0) {
                return this.allAttributes;
            }
            return null;
        }
        --row;
        switch (col) {
            case 0: {
                return this.attributeRegistry.getKey(row);
            }
            case 1: {
                return this.attributeRegistry.getElement(row).getVisibilityModel();
            }
            case 2: {
                return this.attributeRegistry.getRestriction(row);
            }
            case 3: {
                return this.attributeRegistry.getValues(row);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (row == 0 && col != 2) {
            return;
        }
        if (col == 3) {
            return;
        }
        Boolean value = (Boolean)o;
        switch (col) {
            case 1: {
                this.attributeRegistry.setVisibilityModel(row - 1, value);
                break;
            }
            case 2: {
                this.attributeRegistry.setRestrictionModel(row - 1, value);
            }
        }
    }
}

