/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.util.regex.Pattern;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeMatchesCondition
extends ASelectableCondition {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_matches_condition";
    static final String VALUE = "VALUE";
    static final String MATCH_CASE = "MATCH_CASE";
    private final String attribute;
    private final String value;
    private final Pattern searchPattern;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeMatchesCondition(element.getAttribute(ATTRIBUTE, null), element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute(MATCH_CASE, null)));
    }

    public AttributeMatchesCondition(String attribute, String value, boolean matchCase) {
        this.attribute = attribute;
        this.value = value;
        int flags = 32;
        if (!matchCase) {
            flags |= 2;
        }
        this.searchPattern = Pattern.compile(value, flags);
    }

    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        TextController textController = TextController.getController();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            Object originalContent;
            String text;
            if (!attributes.getValueAt(i, 0).equals(this.attribute) || !this.searchPattern.matcher(text = textController.getTransformedTextNoThrow(originalContent = attributes.getValueAt(i, 1), node, null)).find()) continue;
            return true;
        }
        return false;
    }

    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_regexp_matches");
        return ConditionFactory.createDescription(this.attribute, simpleCondition, null, this.isMatchCase(), false);
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(ATTRIBUTE, this.attribute);
        child.setAttribute(VALUE, this.value);
        child.setAttribute(MATCH_CASE, Boolean.toString(this.isMatchCase()));
    }

    protected String getName() {
        return NAME;
    }

    private boolean isMatchCase() {
        return (this.searchPattern.flags() & 2) == 0;
    }
}

