/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeExistsCondition
extends ASelectableCondition {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_exists_condition";
    private final String attribute;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeExistsCondition(element.getAttribute(ATTRIBUTE, null));
    }

    public AttributeExistsCondition(String attribute) {
        this.attribute = attribute;
    }

    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            return true;
        }
        return false;
    }

    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_exist");
        return ConditionFactory.createDescription(this.attribute, simpleCondition, null, false, false);
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(ATTRIBUTE, this.attribute);
    }

    protected String getName() {
        return NAME;
    }
}

