/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.awt.Component;
import java.net.URI;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeBuilder;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.text.TextController;

public class AttributeController
implements IExtension {
    public static final String SHOW_ICON_FOR_ATTRIBUTES = "show_icon_for_attributes";
    private static final Integer ATTRIBUTE_TOOLTIP = 7;
    private static UIIcon attributeIcon = null;
    private final ModeController modeController;

    public static AttributeController getController() {
        return AttributeController.getController(Controller.getCurrentModeController());
    }

    public static AttributeController getController(ModeController modeController) {
        return modeController.getExtension(AttributeController.class);
    }

    public static void install(AttributeController attributeController) {
        Controller.getCurrentModeController().addExtension(AttributeController.class, attributeController);
    }

    public AttributeController(ModeController modeController) {
        this.modeController = modeController;
        MapController mapController = Controller.getCurrentModeController().getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        MapReader mapReader = mapController.getMapReader();
        AttributeBuilder attributeBuilder = new AttributeBuilder(this, mapReader);
        attributeBuilder.registerBy(readManager, writeManager);
        this.registerTooltipProvider();
        this.registerStateIconProvider();
    }

    public NodeAttributeTableModel createAttributeTableModel(NodeModel node) {
        NodeAttributeTableModel attributeModel = node.getExtension(NodeAttributeTableModel.class);
        if (attributeModel != null) {
            return attributeModel;
        }
        attributeModel = new NodeAttributeTableModel(node);
        node.addExtension(attributeModel);
        if (node.areViewsEmpty()) {
            return attributeModel;
        }
        this.modeController.getMapController().nodeRefresh(node);
        return attributeModel;
    }

    public void performInsertRow(NodeAttributeTableModel model, int row, String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void performRegistryAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public void performRegistryAttributeValue(String name, String value, boolean manual) {
        throw new UnsupportedOperationException();
    }

    public void performRegistrySubtreeAttributes(NodeModel model) {
        throw new UnsupportedOperationException();
    }

    public void performRemoveAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public void performRemoveAttributeValue(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public Attribute performRemoveRow(NodeAttributeTableModel model, int row) {
        throw new UnsupportedOperationException();
    }

    public void performReplaceAtributeName(String oldName, String newName) {
        throw new UnsupportedOperationException();
    }

    public void performReplaceAttributeValue(String name, String oldValue, String newValue) {
        throw new UnsupportedOperationException();
    }

    public void performSetColumnWidth(NodeAttributeTableModel model, int col, int width) {
        throw new UnsupportedOperationException();
    }

    public void performSetFontSize(AttributeRegistry registry, int size) {
        throw new UnsupportedOperationException();
    }

    public void performSetRestriction(int row, boolean restricted) {
        throw new UnsupportedOperationException();
    }

    public void performSetValueAt(NodeAttributeTableModel model, Object o, int row, int col) {
        throw new UnsupportedOperationException();
    }

    public void performSetVisibility(int index, boolean isVisible) {
        throw new UnsupportedOperationException();
    }

    private void registerTooltipProvider() {
        this.modeController.addToolTipProvider(ATTRIBUTE_TOOLTIP, new ITooltipProvider(){

            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
                int rowCount = attributes.getRowCount();
                if (rowCount == 0) {
                    return null;
                }
                AttributeRegistry registry = AttributeRegistry.getRegistry(node.getMap());
                TextController textController = TextController.getController(modeController);
                if (registry.getAttributeViewType().equals("extended") && !textController.isMinimized(node)) {
                    return null;
                }
                StringBuilder tooltip = new StringBuilder();
                int fontSize = registry.getFontSize();
                tooltip.append("<html><body><table style='border: 1px black solid; background-color: black;");
                tooltip.append(" font-size: ");
                tooltip.append(fontSize);
                tooltip.append("pt");
                tooltip.append("' width='100%' cellspacing='1' cellpadding='2' ");
                int currentRowCount = attributes.getRowCount();
                for (int i = 0; i < currentRowCount; ++i) {
                    tooltip.append("<tr><td>");
                    tooltip.append(attributes.getValueAt(i, 0));
                    tooltip.append("</td><td>");
                    Object object = attributes.getValueAt(i, 1);
                    String text = this.getTransformedValue(node, textController, object);
                    if (object instanceof URI) {
                        tooltip.append("<a");
                        tooltip.append(" href=\"");
                        tooltip.append(object);
                        tooltip.append("\"");
                        tooltip.append(">");
                        tooltip.append(text);
                        tooltip.append("</a>");
                    } else {
                        tooltip.append(text);
                    }
                    tooltip.append("</td></tr>");
                }
                tooltip.append("</table></body></html>");
                return tooltip.toString();
            }

            private String getTransformedValue(NodeModel node, TextController textController, Object value) {
                try {
                    String text = textController.getTransformedText(value, node, null);
                    boolean markTransformedText = TextController.isMarkTransformedTextSet();
                    String unicodeText = HtmlUtils.unicodeToHTMLUnicodeEntity(text);
                    if (markTransformedText && text != value) {
                        return this.colorize(unicodeText, "green");
                    }
                    return unicodeText;
                }
                catch (Throwable e) {
                    LogUtils.warn(e.getMessage(), e);
                    return this.colorize(TextUtils.format("MainView.errorUpdateText", String.valueOf(value), e.getLocalizedMessage()).replace("\n", "<br>"), "red");
                }
            }

            private String colorize(String text, String color) {
                return "<span style=\"color:" + color + ";font-style:italic;\">" + text + "</span>";
            }
        });
    }

    private void registerStateIconProvider() {
        IconController.getController().addStateIconProvider(new IStateIconProvider(){

            public UIIcon getStateIcon(NodeModel node) {
                NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
                if (attributes.getRowCount() == 0) {
                    return null;
                }
                String showAttributeIcon = MapStyle.getController(AttributeController.this.modeController).getPropertySetDefault(node.getMap(), AttributeController.SHOW_ICON_FOR_ATTRIBUTES);
                boolean showIcon = Boolean.parseBoolean(showAttributeIcon);
                if (showIcon) {
                    if (attributeIcon == null) {
                        attributeIcon = IconStoreFactory.create().getUIIcon("showAttributes.png");
                    }
                    return attributeIcon;
                }
                return null;
            }
        });
    }

    public boolean canEdit() {
        return false;
    }
}

