/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.ExactStringMatchingStrategy;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeContainsCondition
extends ASelectableCondition {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_contains_condition";
    static final String VALUE = "VALUE";
    static final String MATCH_CASE = "MATCH_CASE";
    static final String MATCH_APPROXIMATELY = "MATCH_APPROXIMATELY";
    private final String attribute;
    private final String value;
    private final String comparedValue;
    private final boolean matchCase;
    private final boolean matchApproximately;
    private final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeContainsCondition(element.getAttribute(ATTRIBUTE, null), element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute(MATCH_CASE, null)), Boolean.valueOf(element.getAttribute(MATCH_APPROXIMATELY, null)));
    }

    public AttributeContainsCondition(String attribute, String value, boolean matchCase, boolean matchApproximately) {
        this.attribute = attribute;
        this.value = value;
        this.matchCase = matchCase;
        this.comparedValue = value;
        this.matchApproximately = matchApproximately;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : new ExactStringMatchingStrategy();
    }

    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        TextController textController = TextController.getController();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            Object originalContent;
            String text;
            if (!attributes.getValueAt(i, 0).equals(this.attribute) || !this.stringMatchingStrategy.matches(this.comparedValue, text = textController.getTransformedTextNoThrow(originalContent = attributes.getValueAt(i, 1), node, null), true, this.matchCase)) continue;
            return true;
        }
        return false;
    }

    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_contains");
        return ConditionFactory.createDescription(this.attribute, simpleCondition, this.value, this.matchCase, this.matchApproximately);
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(ATTRIBUTE, this.attribute);
        child.setAttribute(VALUE, this.value);
        child.setAttribute(MATCH_CASE, Boolean.toString(this.matchCase));
        child.setAttribute(MATCH_APPROXIMATELY, Boolean.toString(this.matchApproximately));
    }

    protected String getName() {
        return NAME;
    }
}

