/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.util.NoSuchElementException;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.attribute.AttributeCompareCondition;
import org.freeplane.features.attribute.AttributeContainsCondition;
import org.freeplane.features.attribute.AttributeExistsCondition;
import org.freeplane.features.attribute.AttributeMatchesCondition;
import org.freeplane.features.attribute.AttributeNotExistsCondition;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeRegistryElement;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.link.LinkTransformer;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;
import org.freeplane.n3.nanoxml.XMLElement;

class AttributeConditionController
implements IElementaryConditionController {
    private final ExtendedComboBoxModel values = new ExtendedComboBoxModel();

    public boolean canEditValues(Object selectedItem, NamedObject simpleCond) {
        return this.canSelectValues(selectedItem, simpleCond);
    }

    public boolean canHandle(Object selectedItem) {
        return selectedItem.getClass().equals(String.class);
    }

    public boolean canSelectValues(Object selectedItem, NamedObject simpleCond) {
        return !simpleCond.objectEquals("filter_exist") && !simpleCond.objectEquals("filter_does_not_exist");
    }

    public ASelectableCondition createCondition(Object selectedItem, NamedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately) {
        String attribute = (String)selectedItem;
        if (simpleCondition.objectEquals("filter_exist")) {
            return new AttributeExistsCondition(attribute);
        }
        if (simpleCondition.objectEquals("filter_does_not_exist")) {
            return new AttributeNotExistsCondition(attribute);
        }
        if (simpleCondition.objectEquals("filter_is_equal_to")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 0, true, matchApproximately);
        }
        if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 0, false, matchApproximately);
        }
        if (simpleCondition.objectEquals(">")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 1, true, false);
        }
        if (simpleCondition.objectEquals(">=")) {
            return new AttributeCompareCondition(attribute, value, matchCase, -1, false, false);
        }
        if (simpleCondition.objectEquals("<")) {
            return new AttributeCompareCondition(attribute, value, matchCase, -1, true, false);
        }
        if (simpleCondition.objectEquals("<=")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 1, false, false);
        }
        if (simpleCondition.objectEquals("filter_contains")) {
            return new AttributeContainsCondition(attribute, value.toString(), matchCase, matchApproximately);
        }
        if (simpleCondition.objectEquals("filter_regexp_matches")) {
            return new AttributeMatchesCondition(attribute, value.toString(), matchCase);
        }
        return null;
    }

    public ComboBoxModel getConditionsForProperty(Object selectedItem) {
        return new DefaultComboBoxModel<NamedObject>(new NamedObject[]{TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_regexp_matches"), TextUtils.createTranslatedString("filter_exist"), TextUtils.createTranslatedString("filter_does_not_exist"), TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_is_not_equal_to"), NamedObject.literal(">"), NamedObject.literal(">="), NamedObject.literal("<="), NamedObject.literal("<")});
    }

    public ListModel getFilteredProperties() {
        AttributeRegistry registry = AttributeRegistry.getRegistry(Controller.getCurrentController().getMap());
        if (registry != null) {
            return registry.getListBoxModel();
        }
        return new DefaultListModel();
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, NamedObject selectedCondition) {
        if (selectedCondition.objectEquals("filter_contains") || selectedCondition.objectEquals("filter_regexp_matches")) {
            return new FixedBasicComboBoxEditor();
        }
        return FrameController.getTextDateTimeEditor();
    }

    public ComboBoxModel getValuesForProperty(Object selectedItem, NamedObject simpleCond) {
        MapModel map = Controller.getCurrentController().getMap();
        AttributeRegistry registry = AttributeRegistry.getRegistry(map);
        try {
            AttributeRegistryElement element = registry.getElement((Comparable<?>)((Object)selectedItem.toString()));
            SortedComboBoxModel list = element.getValues();
            SortedComboBoxModel linkedList = new SortedComboBoxModel();
            for (int i = 0; i < list.getSize(); ++i) {
                Object value = list.getElementAt(i);
                Object transformedValue = new LinkTransformer(Controller.getCurrentModeController(), 1).transformContent(value, map);
                linkedList.add(transformedValue);
            }
            this.values.setExtensionList(linkedList);
        }
        catch (NoSuchElementException e) {
            this.values.setExtensionList(null);
        }
        return this.values;
    }

    public boolean isCaseDependent(Object selectedItem, NamedObject simpleCond) {
        return true;
    }

    public boolean supportsApproximateMatching(Object property, NamedObject simpleCond) {
        return true;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("attribute_compare_condition")) {
            return AttributeCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_exists_condition")) {
            return AttributeExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_not_exists_condition")) {
            return AttributeNotExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_contains_condition")) {
            return AttributeContainsCondition.load(element);
        }
        return null;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, NamedObject selectedCondition) {
        if (selectedCondition.objectEquals("filter_contains") || selectedCondition.objectEquals("filter_regexp_matches")) {
            return null;
        }
        return new TypedListCellRenderer();
    }
}

