/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CompareConditionAdapter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeCompareCondition
extends CompareConditionAdapter {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String COMPARATION_RESULT = "COMPARATION_RESULT";
    static final String NAME = "attribute_compare_condition";
    static final String SUCCEED = "SUCCEED";
    private final String attribute;
    private final int comparationResult;
    private final boolean succeed;

    static ASelectableCondition load(XMLElement element) {
        String attr = element.getAttribute(ATTRIBUTE, null);
        Object value = element.getAttribute("VALUE", null);
        if (value == null) {
            String spec = element.getAttribute("OBJECT", null);
            value = TypeReference.create(spec);
        }
        boolean matchCase = TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_CASE", null));
        int compResult = Integer.parseInt(element.getAttribute(COMPARATION_RESULT, null));
        boolean succeed = TreeXmlReader.xmlToBoolean(element.getAttribute(SUCCEED, null));
        boolean matchApproximately = TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_APPROXIMATELY", null));
        return new AttributeCompareCondition(attr, value, matchCase, compResult, succeed, matchApproximately);
    }

    public AttributeCompareCondition(String attribute, Object value, boolean matchCase, int comparationResult, boolean succeed, boolean matchApproximately) {
        super(value, matchCase, matchApproximately);
        this.attribute = attribute;
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    public boolean isEqualityCondition() {
        return this.comparationResult == 0;
    }

    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        TextController textController = TextController.getController();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            try {
                if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
                Object originalContent = attributes.getValueAt(i, 1);
                String text = textController.getTransformedTextNoThrow(originalContent, node, null);
                this.compareTo(text);
                if (!this.isComparisonOK() || this.succeed != (this.getComparisonResult() == this.comparationResult)) continue;
                return true;
            }
            catch (NumberFormatException fne) {
                // empty catch block
            }
        }
        return false;
    }

    protected String createDescription() {
        return super.createDescription(this.attribute, this.comparationResult, this.succeed);
    }

    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(ATTRIBUTE, this.attribute);
        child.setAttribute(COMPARATION_RESULT, Integer.toString(this.comparationResult));
        child.setAttribute(SUCCEED, TreeXmlWriter.BooleanToXml(this.succeed));
        child.setAttribute("MATCH_APPROXIMATELY", TreeXmlWriter.BooleanToXml(this.matchApproximately));
    }

    protected String getName() {
        return NAME;
    }
}

