/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.collection;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.util.collection.DoubleListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedComboBoxModel
extends DefaultComboBoxModel {
    private static final long serialVersionUID = 1L;
    private ListModel extension = null;
    private final ExtensionDataListener extensionDataListener = new ExtensionDataListener();

    public ExtendedComboBoxModel() {
    }

    public ExtendedComboBoxModel(Object[] o) {
        super(o);
    }

    public ExtendedComboBoxModel(Vector<?> v) {
        super(v);
    }

    public void addExtensionList(ListModel listModel) {
        if (this.extension == null) {
            this.setExtensionList(listModel);
        } else {
            int oldSize = this.getOwnSize();
            this.extension.removeListDataListener(this.extensionDataListener);
            this.extension = new DoubleListModel(this.extension, listModel);
            int newListSize = listModel.getSize();
            if (newListSize != 0) {
                this.fireIntervalAdded(listModel, oldSize + 1, oldSize + newListSize);
            }
            this.extension.addListDataListener(this.extensionDataListener);
        }
    }

    @Override
    public Object getElementAt(int i) {
        int s = this.getOwnSize();
        if (i < s || this.extension == null) {
            return super.getElementAt(i);
        }
        return this.extension.getElementAt(i - s);
    }

    private int getExtensionSize() {
        return this.extension != null ? this.extension.getSize() : 0;
    }

    @Override
    public int getIndexOf(Object o) {
        int idx = super.getIndexOf(o);
        if (idx > -1 || this.extension == null) {
            return idx;
        }
        int extIdx = this.getExtensionIndex(o);
        return extIdx > -1 ? extIdx + this.getOwnSize() : -1;
    }

    private int getExtensionIndex(Object o) {
        int size = this.extension.getSize();
        for (int count = 0; count < size; ++count) {
            if (!this.extension.getElementAt(count).equals(o)) continue;
            return count;
        }
        return -1;
    }

    private ExtendedComboBoxModel getModel() {
        return this;
    }

    private int getOwnSize() {
        return super.getSize();
    }

    @Override
    public int getSize() {
        return this.getOwnSize() + this.getExtensionSize();
    }

    @Override
    public void insertElementAt(Object o, int i) {
        super.insertElementAt(o, Math.min(this.getOwnSize(), i));
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        if (this.extension != null) {
            this.setExtensionList(null);
        }
    }

    @Override
    public void removeElement(Object o) {
        super.removeElement(o);
    }

    @Override
    public void removeElementAt(int i) {
        if (i < this.getOwnSize()) {
            super.removeElementAt(i);
        }
    }

    public void setExtensionList(ListModel sortedListModel) {
        int extensionSize;
        int ownSize = this.getOwnSize();
        if (this.extension != null) {
            this.extension.removeListDataListener(this.extensionDataListener);
            extensionSize = this.getExtensionSize();
            if (extensionSize > 0) {
                this.fireIntervalRemoved(this, ownSize, ownSize + extensionSize - 1);
            }
        }
        this.extension = sortedListModel;
        extensionSize = this.getExtensionSize();
        if (extensionSize > 0) {
            this.fireIntervalAdded(this, ownSize, ownSize + extensionSize - 1);
        }
        if (this.extension != null) {
            this.extension.addListDataListener(this.extensionDataListener);
        }
    }

    private class ExtensionDataListener
    implements ListDataListener {
        private ExtensionDataListener() {
        }

        public void contentsChanged(ListDataEvent e) {
            int size = ExtendedComboBoxModel.this.getOwnSize();
            ExtendedComboBoxModel.this.fireContentsChanged(ExtendedComboBoxModel.this.getModel(), size + e.getIndex0(), size + e.getIndex1());
        }

        public void intervalAdded(ListDataEvent e) {
            int size = ExtendedComboBoxModel.this.getOwnSize();
            ExtendedComboBoxModel.this.fireIntervalAdded(ExtendedComboBoxModel.this.getModel(), size + e.getIndex0(), size + e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
            int size = ExtendedComboBoxModel.this.getOwnSize();
            ExtendedComboBoxModel.this.fireIntervalRemoved(ExtendedComboBoxModel.this.getModel(), size + e.getIndex0(), size + e.getIndex1());
        }
    }
}

