/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.collection;

import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class DoubleListModel
extends AbstractListModel
implements ListModel {
    private static final long serialVersionUID = 1L;
    private final ListModel first;
    private final ListModel second;

    public DoubleListModel(final ListModel first, ListModel second) {
        this.first = first;
        this.second = second;
        first.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                DoubleListModel.this.fireContentsChanged(e.getSource(), e.getIndex0(), e.getIndex1());
            }

            public void intervalAdded(ListDataEvent e) {
                DoubleListModel.this.fireIntervalAdded(e.getSource(), e.getIndex0(), e.getIndex1());
            }

            public void intervalRemoved(ListDataEvent e) {
                DoubleListModel.this.fireIntervalRemoved(e.getSource(), e.getIndex0(), e.getIndex1());
            }
        });
        second.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                int firstSize = first.getSize();
                DoubleListModel.this.fireContentsChanged(e.getSource(), firstSize + e.getIndex0(), firstSize + e.getIndex1());
            }

            public void intervalAdded(ListDataEvent e) {
                int firstSize = first.getSize();
                DoubleListModel.this.fireIntervalAdded(e.getSource(), firstSize + e.getIndex0(), firstSize + e.getIndex1());
            }

            public void intervalRemoved(ListDataEvent e) {
                int firstSize = first.getSize();
                DoubleListModel.this.fireIntervalRemoved(e.getSource(), firstSize + e.getIndex0(), firstSize + e.getIndex1());
            }
        });
    }

    public Object getElementAt(int index) {
        int firstSize = this.first.getSize();
        return index < firstSize ? this.first.getElementAt(index) : this.second.getElementAt(index - firstSize);
    }

    public int getSize() {
        return this.first.getSize() + this.second.getSize();
    }
}

