/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.url.CleaningInputStream;

public class XsltPipeReaderFactory {
    public Reader getUpdateReader(File file, String xsltScript) throws FileNotFoundException, IOException {
        try {
            String updatedXml = this.transform(file, xsltScript);
            return new StringReader(updatedXml);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            UITools.errorMessage(TextUtils.format("update_failed", String.valueOf(message)));
            LogUtils.warn(ex);
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            return this.getActualReader(input);
        }
    }

    public String transform(final File file, String xsltScript) throws InterruptedException, TransformerException {
        final URL updaterUrl = ResourceController.getResourceController().getResource(xsltScript);
        if (updaterUrl == null) {
            throw new IllegalArgumentException(xsltScript + " not found.");
        }
        StringWriter writer = new StringWriter();
        final StreamResult result = new StreamResult(writer);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TransformerRunnable
        implements Runnable {
            private Throwable thrownException = null;

            TransformerRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TransformerFactory transFact = TransformerFactory.newInstance();
                BufferedInputStream xsltInputStream = null;
                BufferedInputStream input = null;
                try {
                    xsltInputStream = new BufferedInputStream(updaterUrl.openStream());
                    StreamSource xsltSource = new StreamSource(xsltInputStream);
                    input = new BufferedInputStream(new FileInputStream(file));
                    CleaningInputStream cleanedInput = new CleaningInputStream(input);
                    InputStreamReader reader = new InputStreamReader((InputStream)cleanedInput, cleanedInput.isUtf8() ? Charset.forName("UTF-8") : FileUtils.defaultCharset());
                    Transformer trans = transFact.newTransformer(xsltSource);
                    trans.transform(new StreamSource(reader), result);
                }
                catch (Exception ex) {
                    try {
                        LogUtils.warn(ex);
                        this.thrownException = ex;
                    }
                    catch (Throwable throwable) {
                        FileUtils.silentlyClose(input, xsltInputStream);
                        throw throwable;
                    }
                    FileUtils.silentlyClose(input, xsltInputStream);
                }
                FileUtils.silentlyClose(input, xsltInputStream);
            }

            public Throwable thrownException() {
                return this.thrownException;
            }
        }
        TransformerRunnable transformer = new TransformerRunnable();
        Thread transformerThread = new Thread((Runnable)transformer, "XSLT");
        transformerThread.start();
        transformerThread.join();
        Throwable thrownException = transformer.thrownException();
        if (thrownException != null) {
            throw new TransformerException(thrownException);
        }
        String updatedXml = writer.getBuffer().toString();
        return updatedXml;
    }

    public Reader getActualReader(InputStream file) throws FileNotFoundException {
        return new InputStreamReader(file, FileUtils.defaultCharset());
    }
}

