/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.IndexedTree;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuUtils {
    public static DefaultMutableTreeNode createMenuEntryTree(String menuRootKey, MenuBuilder menuBuilder) {
        HashMap<String, KeyStroke> menuKeyToKeyStrokeMap = MenuUtils.invertAcceleratorMap(menuBuilder.getAcceleratorMap());
        DefaultMutableTreeNode menuRoot = menuBuilder.get(menuRootKey);
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode(MenuUtils.menuNode2menuEntryNode(menuRoot, menuKeyToKeyStrokeMap));
        MenuUtils.addChildrenRecursively(treeRoot, menuRoot.children(), menuKeyToKeyStrokeMap);
        return treeRoot;
    }

    private static void addChildrenRecursively(DefaultMutableTreeNode treeNode, Enumeration menuChildren, HashMap<String, KeyStroke> menuKeyToKeyStrokeMap) {
        while (menuChildren.hasMoreElements()) {
            DefaultMutableTreeNode childMenu = (DefaultMutableTreeNode)menuChildren.nextElement();
            DefaultMutableTreeNode treeChild = MenuUtils.menuNode2menuEntryNode(childMenu, menuKeyToKeyStrokeMap);
            if (treeChild != null) {
                treeNode.add(treeChild);
                MenuUtils.addChildrenRecursively(treeChild, childMenu.children(), menuKeyToKeyStrokeMap);
                continue;
            }
            MenuUtils.addChildrenRecursively(treeNode, childMenu.children(), menuKeyToKeyStrokeMap);
        }
    }

    private static DefaultMutableTreeNode menuNode2menuEntryNode(DefaultMutableTreeNode menuNode, HashMap<String, KeyStroke> menuKeyToKeyStrokeMap) {
        IndexedTree.Node node = (IndexedTree.Node)menuNode;
        Object userObject = menuNode.getUserObject();
        if (userObject instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)userObject;
            IFreeplaneAction action = (IFreeplaneAction)jMenuItem.getAction();
            String key = String.valueOf(node.getKey());
            String iconKey = action == null ? null : action.getIconKey();
            return new DefaultMutableTreeNode(new MenuEntry(key, jMenuItem.getText(), iconKey, menuKeyToKeyStrokeMap.get(key), jMenuItem.getToolTipText()));
        }
        return null;
    }

    public static DefaultMutableTreeNode createAcceleratebleMenuEntryTree(String menuRootKey, MenuBuilder menuBuilder) {
        DefaultMutableTreeNode menuEntryTreeNode = MenuUtils.createMenuEntryTree(menuRootKey, menuBuilder);
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(menuEntryTreeNode.getUserObject());
        MenuUtils.addAcceleratableChildrenRecursively(result, menuEntryTreeNode.children());
        return result;
    }

    private static void addAcceleratableChildrenRecursively(DefaultMutableTreeNode target, Enumeration sourceChildren) {
        while (sourceChildren.hasMoreElements()) {
            DefaultMutableTreeNode sourceChild = (DefaultMutableTreeNode)sourceChildren.nextElement();
            MenuEntry menuEntry = (MenuEntry)sourceChild.getUserObject();
            if (sourceChild.isLeaf()) {
                if (menuEntry.getKeyStroke() == null) continue;
                target.add(new DefaultMutableTreeNode(menuEntry));
                continue;
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(menuEntry);
            target.add(newNode);
            MenuUtils.addAcceleratableChildrenRecursively(newNode, sourceChild.children());
            if (!newNode.isLeaf()) continue;
            target.remove(newNode);
        }
    }

    private static HashMap<String, KeyStroke> invertAcceleratorMap(Map<KeyStroke, IndexedTree.Node> acceleratorMap) {
        HashMap<String, KeyStroke> result = new HashMap<String, KeyStroke>();
        for (Map.Entry<KeyStroke, IndexedTree.Node> entry : acceleratorMap.entrySet()) {
            result.put(String.valueOf(entry.getValue().getKey()), entry.getKey());
        }
        return result;
    }

    public static void insertAsNodeModelRecursively(NodeModel nodeModel, Enumeration children, MapController mapController) {
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            NodeModel newNodeModel = MenuUtils.insertAsNodeModel(nodeModel, child, mapController);
            if (child.isLeaf()) continue;
            MenuUtils.insertAsNodeModelRecursively(newNodeModel, child.children(), mapController);
        }
    }

    private static NodeModel insertAsNodeModel(NodeModel nodeModel, DefaultMutableTreeNode treeNode, MapController mapController) {
        MindIcon mindIcon;
        MenuEntry menuEntry = (MenuEntry)treeNode.getUserObject();
        String text = menuEntry.getKeyStroke() == null ? menuEntry.getLabel() : menuEntry.getLabel() + ": " + MenuUtils.formatKeyStroke(menuEntry.getKeyStroke());
        NodeModel newNodeModel = mapController.newNode(text, nodeModel.getMap());
        if (!treeNode.isLeaf()) {
            newNodeModel.setFolded(true);
        }
        if (menuEntry.getIconKey() != null && (mindIcon = menuEntry.createMindIcon()) != null) {
            newNodeModel.addIcon(mindIcon);
        }
        nodeModel.insert(newNodeModel);
        return newNodeModel;
    }

    public static String formatKeyStroke(KeyStroke keyStroke) {
        String keyModifiersText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
        return keyModifiersText.length() == 0 ? keyText : keyModifiersText + "+" + keyText;
    }

    public static IndexedTree.Node findAssignedMenuItemNodeRecursively(DefaultMutableTreeNode menubarNode, KeyStroke keystroke) {
        Enumeration<TreeNode> children = menubarNode.children();
        while (children.hasMoreElements()) {
            JMenuItem childMenuItem;
            IndexedTree.Node child = (IndexedTree.Node)children.nextElement();
            Object childUserObject = child.getUserObject();
            if (childUserObject instanceof JMenuItem && keystroke.equals((childMenuItem = (JMenuItem)childUserObject).getAccelerator())) {
                return child;
            }
            IndexedTree.Node assignedMenuItemNode = MenuUtils.findAssignedMenuItemNodeRecursively(child, keystroke);
            if (assignedMenuItemNode == null) continue;
            return assignedMenuItemNode;
        }
        return null;
    }

    public static String makeAcceleratorKey(String menuItemKey) {
        return "acceleratorForMindMap/$" + menuItemKey + "$0";
    }

    public static void executeMenuItems(List<String> menuItemKeys) {
        LogUtils.info("menu items to execute: " + menuItemKeys);
        MenuBuilder menuBuilder = MenuUtils.getMenuBuilder();
        for (String menuItemKey : menuItemKeys) {
            DefaultMutableTreeNode treeNode = menuBuilder.get(menuItemKey);
            if (treeNode == null || !treeNode.isLeaf() || !(treeNode.getUserObject() instanceof JMenuItem)) {
                UITools.errorMessage(TextUtils.format("MenuUtils.invalid_menuitem", menuItemKey));
                return;
            }
            JMenuItem menuItem = (JMenuItem)treeNode.getUserObject();
            Action action = menuItem.getAction();
            LogUtils.info("executing " + menuItem.getText() + "(" + menuItemKey + ")");
            ActionEvent e = new ActionEvent(menuItem, 0, null);
            action.actionPerformed(e);
        }
    }

    private static MenuBuilder getMenuBuilder() {
        ModeController modeController = Controller.getCurrentModeController();
        MenuBuilder menuBuilder = modeController.getUserInputListenerFactory().getMenuBuilder();
        return menuBuilder;
    }

    public static Icon getMenuItemIcon(String menuItemKey) {
        DefaultMutableTreeNode treeNode = MenuUtils.getMenuBuilder().get(menuItemKey);
        if (treeNode == null || !treeNode.isLeaf() || !(treeNode.getUserObject() instanceof JMenuItem)) {
            return null;
        }
        JMenuItem menuItem = (JMenuItem)treeNode.getUserObject();
        return menuItem.getIcon();
    }

    public static class MenuEntry {
        private final String key;
        private final String label;
        private final String iconKey;
        private final KeyStroke keyStroke;
        private final String toolTipText;

        public MenuEntry(String key, String label, String iconKey, KeyStroke keyStroke, String toolTipText) {
            this.key = key;
            this.label = label;
            this.iconKey = iconKey;
            this.keyStroke = keyStroke;
            this.toolTipText = toolTipText;
        }

        public MenuEntry(String key, String label) {
            this(key, label, null, null, null);
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIconKey() {
            return this.iconKey;
        }

        public KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public MindIcon createMindIcon() {
            String resource = ResourceController.getResourceController().getProperty(this.iconKey, null);
            if (resource == null) {
                return null;
            }
            return new MindIcon(resource.replaceAll("/images/(.*).png", "../$1"));
        }

        public String toString() {
            return this.label;
        }
    }
}

