/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LoggingOutputStream;
import org.freeplane.core.util.StdFormatter;

public class LogUtils {
    private static final Logger LOGGER = Logger.global;
    private static boolean loggerCreated = false;

    public static void createLogger() {
        if (loggerCreated) {
            return;
        }
        loggerCreated = true;
        Handler mFileHandler = null;
        Logger parentLogger = Logger.getAnonymousLogger().getParent();
        Handler[] handlers = parentLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (!(handler instanceof ConsoleHandler)) continue;
            parentLogger.removeHandler(handler);
        }
        try {
            String logDirectoryPath = LogUtils.getLogDirectory();
            File logDirectory = new File(logDirectoryPath);
            logDirectory.mkdirs();
            if (logDirectory.isDirectory()) {
                String pathPattern = logDirectoryPath + File.separatorChar + "log";
                mFileHandler = new FileHandler(pathPattern, 1400000, 5, false);
                mFileHandler.setFormatter(new StdFormatter());
                parentLogger.addHandler(mFileHandler);
            }
            ConsoleHandler stdConsoleHandler = new ConsoleHandler();
            stdConsoleHandler.setFormatter(new StdFormatter());
            if (System.getProperty("java.util.logging.config.file", null) == null) {
                mFileHandler.setLevel(Level.INFO);
                stdConsoleHandler.setLevel(Level.INFO);
            }
            parentLogger.addHandler(stdConsoleHandler);
            Logger logger = Logger.getLogger(StdFormatter.STDOUT.getName());
            LoggingOutputStream los = new LoggingOutputStream(logger, StdFormatter.STDOUT);
            System.setOut(new PrintStream(los, true));
            logger = Logger.getLogger(StdFormatter.STDERR.getName());
            los = new LoggingOutputStream(logger, StdFormatter.STDERR);
            System.setErr(new PrintStream(los, true));
        }
        catch (Exception e) {
            LogUtils.warn("Error creating logging File Handler", e);
        }
    }

    public static String getLogDirectory() {
        String logDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory() + File.separatorChar + "logs";
        return logDirectory;
    }

    public static void info(String string) {
        LOGGER.log(Level.INFO, string);
    }

    public static void info(Transferable t) {
        System.out.println();
        System.out.println("BEGIN OF Transferable:\t" + t);
        DataFlavor[] dataFlavors = t.getTransferDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            System.out.println("  Flavor:\t" + dataFlavors[i]);
            System.out.println("    Supported:\t" + t.isDataFlavorSupported(dataFlavors[i]));
            try {
                System.out.println("    Content:\t" + t.getTransferData(dataFlavors[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("END OF Transferable");
        System.out.println();
    }

    public static void severe(String message) {
        LOGGER.log(Level.SEVERE, message);
    }

    public static void severe(String comment, Throwable e) {
        if (e instanceof SecurityException || e.getCause() instanceof SecurityException) {
            LogUtils.warn(comment, e);
        } else {
            LOGGER.log(Level.SEVERE, comment, e);
        }
    }

    public static void severe(Throwable e) {
        LogUtils.severe("", e);
    }

    public static void warn(String msg) {
        LOGGER.log(Level.WARNING, msg);
    }

    public static void warn(String comment, Throwable e) {
        LOGGER.log(Level.WARNING, comment, e);
    }

    public static void warn(Throwable e) {
        LogUtils.warn("", e);
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

