/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.SAXParserFactory;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.XHTMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUtils {
    private static final Pattern FIND_TAGS_PATTERN = Pattern.compile("([^<]*)(<[^>]+>)");
    private static final Pattern HTML_PATTERN = Pattern.compile("(?s)^\\s*<\\s*html[^>]*>.*", 2);
    private static Pattern[] PATTERNS;
    private static HtmlUtils sInstance;
    private static final Pattern SLASHED_TAGS_PATTERN;
    private static final Pattern TAGS_PATTERN;

    public static HtmlUtils getInstance() {
        return sInstance;
    }

    public static String htmlToPlain(String text) {
        return HtmlUtils.htmlToPlain(text, true, true);
    }

    public static String htmlToPlain(String text, boolean strictHTMLOnly) {
        return HtmlUtils.htmlToPlain(text, strictHTMLOnly, true);
    }

    public static String htmlToPlain(String text, boolean strictHTMLOnly, boolean removeNewLines) {
        if (strictHTMLOnly && !HtmlUtils.isHtmlNode(text)) {
            return text;
        }
        if (PATTERNS == null) {
            PATTERNS = new Pattern[]{Pattern.compile("(?ims)>[\n\t]+"), Pattern.compile("(?ims)[\n\t ]+"), Pattern.compile("(?ims)<br[^>]*>"), Pattern.compile("(?ims)<p[^>]*>\\s+"), Pattern.compile("(?ims)<div[^>]*>\\s+"), Pattern.compile("(?ims)<tr[^>]*>\\s+"), Pattern.compile("(?ims)<dt[^>]*>"), Pattern.compile("(?ims)<dd[^>]*>"), Pattern.compile("(?ims)<td[^>]*>"), Pattern.compile("(?ims)<[uo]l[^>]*>"), Pattern.compile("(?ims)<li[^>]*>"), Pattern.compile("(?ims) *</[^>]*>"), Pattern.compile("(?ims)<[^/][^>]*> *"), Pattern.compile("^\n+"), Pattern.compile("(?ims)&lt;"), Pattern.compile("(?ims)&gt;"), Pattern.compile("(?ims)&quot;"), Pattern.compile("(?ims)&nbsp;"), Pattern.compile("(?ims)&amp;"), Pattern.compile("(?ims)[ \t]+\n")};
        }
        String intermediate = text;
        int i = 0;
        intermediate = PATTERNS[i++].matcher(intermediate).replaceAll(">");
        if (removeNewLines) {
            intermediate = PATTERNS[i++].matcher(intermediate).replaceAll(" ");
        }
        int n = ++i;
        intermediate = PATTERNS[n].matcher(intermediate).replaceAll("\n");
        int n2 = ++i;
        intermediate = PATTERNS[n2].matcher(intermediate).replaceAll("\n");
        int n3 = ++i;
        intermediate = PATTERNS[n3].matcher(intermediate).replaceAll("\n");
        int n4 = ++i;
        intermediate = PATTERNS[n4].matcher(intermediate).replaceAll("\n");
        int n5 = ++i;
        intermediate = PATTERNS[n5].matcher(intermediate).replaceAll("\n");
        int n6 = ++i;
        intermediate = PATTERNS[n6].matcher(intermediate).replaceAll("\n   ");
        int n7 = ++i;
        intermediate = PATTERNS[n7].matcher(intermediate).replaceAll(" ");
        int n8 = ++i;
        intermediate = PATTERNS[n8].matcher(intermediate).replaceAll("\n");
        int n9 = ++i;
        intermediate = PATTERNS[n9].matcher(intermediate).replaceAll("\n   * ");
        int n10 = ++i;
        intermediate = PATTERNS[n10].matcher(intermediate).replaceAll("");
        int n11 = ++i;
        ++i;
        intermediate = PATTERNS[n11].matcher(intermediate).replaceAll("");
        if (removeNewLines) {
            intermediate = PATTERNS[i++].matcher(intermediate).replaceAll("");
        }
        intermediate = intermediate.trim();
        intermediate = HtmlUtils.unescapeHTMLUnicodeEntity(intermediate);
        int n12 = ++i;
        intermediate = PATTERNS[n12].matcher(intermediate).replaceAll("<");
        int n13 = ++i;
        intermediate = PATTERNS[n13].matcher(intermediate).replaceAll(">");
        int n14 = ++i;
        intermediate = PATTERNS[n14].matcher(intermediate).replaceAll("\"");
        int n15 = ++i;
        intermediate = PATTERNS[n15].matcher(intermediate).replaceAll(" ");
        int n16 = ++i;
        intermediate = PATTERNS[n16].matcher(intermediate).replaceAll("&");
        int n17 = ++i;
        ++i;
        intermediate = PATTERNS[n17].matcher(intermediate).replaceAll("\n");
        intermediate = intermediate.replace('\u00a0', ' ');
        return intermediate;
    }

    public static boolean isHtmlNode(String text) {
        char ch;
        for (int i = 0; i < text.length() && (ch = text.charAt(i)) != '<'; ++i) {
            if (Character.isWhitespace(ch) && i != text.length()) continue;
            return false;
        }
        return HTML_PATTERN.matcher(text).matches();
    }

    public static String plainToHTML(String text) {
        String textTabsExpanded = text.replaceAll("\t", "         ");
        StringBuilder result = new StringBuilder(textTabsExpanded.length());
        int lengthMinus1 = textTabsExpanded.length() - 1;
        result.append("<html><body><p>");
        block7: for (int i = 0; i < textTabsExpanded.length(); ++i) {
            char myChar = textTabsExpanded.charAt(i);
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case ' ': {
                    if (i > 0 && i < lengthMinus1 && textTabsExpanded.charAt(i - 1) > ' ' && textTabsExpanded.charAt(i + 1) > ' ') {
                        result.append(' ');
                        continue block7;
                    }
                    result.append("&nbsp;");
                    continue block7;
                }
                case '\n': {
                    result.append("</p>\n<p>");
                    continue block7;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        result.append("</p></body></html>");
        return result.toString();
    }

    public static String removeAllTagsFromString(String text) {
        return TAGS_PATTERN.matcher(text).replaceAll("");
    }

    public static String removeHtmlTagsFromString(String text) {
        if (HtmlUtils.isHtmlNode(text)) {
            return HtmlUtils.removeAllTagsFromString(text);
        }
        return text;
    }

    public static String toXMLEscapedText(String text) {
        int len = text.length();
        StringBuilder result = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        return result.toString();
    }

    public static String toXMLEscapedTextExpandingWhitespace(String text) {
        text = text.replaceAll("\t", "         ");
        int len = text.length();
        StringBuilder result = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case ' ': {
                    if (i > 0 && i < len - 1 && text.charAt(i - 1) > ' ' && text.charAt(i + 1) > ' ') {
                        result.append(' ');
                        continue block7;
                    }
                    result.append("&nbsp;");
                    continue block7;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        return result.toString();
    }

    public static String toXMLUnescapedText(String text) {
        return text.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
    }

    public static String unescapeHTMLUnicodeEntity(String text) {
        StringBuilder resultBuilder = new StringBuilder(text.length());
        StringBuilder entity = new StringBuilder();
        boolean readingEntity = false;
        for (int i = 0; i < text.length(); ++i) {
            char myChar = text.charAt(i);
            if (readingEntity) {
                if (myChar == ';') {
                    block10: {
                        if (entity.charAt(0) == '#') {
                            try {
                                char c = entity.charAt(1) == 'x' ? (char)Integer.parseInt(entity.substring(2), 16) : (char)Integer.parseInt(entity.substring(1), 10);
                                if (c >= ' ' || c == '\t' || c == '\r' || c == '\n') {
                                    resultBuilder.append(c);
                                    break block10;
                                }
                                resultBuilder.append(' ');
                            }
                            catch (NumberFormatException e) {
                                resultBuilder.append('&').append((CharSequence)entity).append(';');
                            }
                        } else {
                            resultBuilder.append('&').append((CharSequence)entity).append(';');
                        }
                    }
                    entity.setLength(0);
                    readingEntity = false;
                    continue;
                }
                entity.append(myChar);
                continue;
            }
            if (myChar == '&') {
                readingEntity = true;
                continue;
            }
            resultBuilder.append(myChar);
        }
        if (entity.length() > 0) {
            resultBuilder.append('&').append((CharSequence)entity);
        }
        String result = resultBuilder.toString();
        return result;
    }

    public static String unicodeToHTMLUnicodeEntity(String text) {
        StringBuilder result = null;
        for (int i = 0; i < text.length(); ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue < ' ' || intValue > '~') {
                if (result == null) {
                    result = new StringBuilder((int)((double)text.length() * 1.2));
                    result.append(text.subSequence(0, i));
                }
                result.append("&#x").append(Integer.toString(intValue, 16)).append(';');
                continue;
            }
            if (result == null) continue;
            result.append(myChar);
        }
        if (result != null) {
            return result.toString();
        }
        return text;
    }

    private HtmlUtils() {
    }

    public static int getMaximalOriginalPosition(int pI, ArrayList<IndexPair> pListOfIndices) {
        for (int i = pListOfIndices.size() - 1; i >= 0; --i) {
            IndexPair pair = pListOfIndices.get(i);
            if (pI < pair.pureTextStart) continue;
            if (!pair.mIsTag) {
                return pair.originalStart + pI - pair.pureTextStart;
            }
            return pair.originalEnd;
        }
        throw new IllegalArgumentException("Position " + pI + " not found.");
    }

    public static int getMinimalOriginalPosition(int pI, ArrayList<IndexPair> pListOfIndices) {
        for (IndexPair pair : pListOfIndices) {
            if (pI < pair.pureTextStart || pI > pair.pureTextEnd) continue;
            return pair.originalStart + pI - pair.pureTextStart;
        }
        throw new IllegalArgumentException("Position " + pI + " not found.");
    }

    public static String getReplaceResult(Pattern pattern, String text, String replacement) {
        return new HtmlReplacer().getReplaceResult(pattern, replacement, text);
    }

    public static boolean isWellformedXml(String xml) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.newSAXParser().parse(new InputSource(new StringReader(xml)), new DefaultHandler());
            return true;
        }
        catch (SAXParseException e) {
            LogUtils.warn("XmlParseError on line " + e.getLineNumber() + " of " + xml, e);
        }
        catch (Exception e) {
            LogUtils.severe("XmlParseError", e);
        }
        return false;
    }

    public static String toHtml(String xhtmlText) {
        return SLASHED_TAGS_PATTERN.matcher(xhtmlText).replaceAll("<$1>");
    }

    public static String toXhtml(String htmlText) {
        if (!HtmlUtils.isHtmlNode(htmlText)) {
            return null;
        }
        StringReader reader = new StringReader(htmlText);
        StringWriter writer = new StringWriter();
        try {
            XHTMLWriter.html2xhtml(reader, writer);
            String resultXml = writer.toString();
            if (!HtmlUtils.isWellformedXml(resultXml)) {
                return HtmlUtils.toXMLEscapedText(htmlText);
            }
            return resultXml;
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
        catch (BadLocationException e) {
            LogUtils.severe(e);
        }
        htmlText = htmlText.replaceAll("<", "&gt;");
        htmlText = htmlText.replaceAll(">", "&lt;");
        return htmlText;
    }

    public static int endOfText(String html) {
        int bodyEndPos = html.lastIndexOf("</body>");
        if (bodyEndPos == -1) {
            bodyEndPos = html.lastIndexOf("</BODY>");
        }
        if (bodyEndPos == -1) {
            bodyEndPos = html.lastIndexOf("</html>");
        }
        if (bodyEndPos == -1) {
            bodyEndPos = html.lastIndexOf("</HTML>");
        }
        if (bodyEndPos == -1) {
            bodyEndPos = html.length();
        }
        return bodyEndPos;
    }

    public static String combineTextWithExceptionInfo(String text, Exception ex) {
        String escaped = HtmlUtils.toXMLEscapedText(text).replaceAll("\n", "<br>\n");
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append(ex.getClass().getSimpleName());
        sb.append("<br>\n");
        sb.append(ex.getMessage());
        sb.append("<br>\n");
        sb.append(escaped);
        String string = sb.toString();
        return string;
    }

    public static String element(String name, String content) {
        return HtmlUtils.element(name, null, content);
    }

    public static String element(String name, Map<String, String> attributes, String content) {
        StringBuilder builder = new StringBuilder();
        builder.append("<").append(name).append(HtmlUtils.toAttributeString(attributes)).append(">");
        if (content != null && content.length() > 0) {
            builder.append(content);
        }
        return builder.append("</").append(name).append(">").toString();
    }

    private static String toAttributeString(Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(entry.getKey());
            builder.append("=\"");
            builder.append(entry.getKey());
            builder.append('\"');
        }
        return builder.toString();
    }

    public static String extractRawBody(String text) {
        int textBegin;
        int start = text.indexOf("<body>");
        if (start != -1) {
            textBegin = start + "<body>".length();
        } else {
            start = text.indexOf("</head>");
            if (start != -1) {
                textBegin = start + "</head>".length();
            } else {
                start = text.indexOf("<html>");
                textBegin = start + "<html>".length();
            }
        }
        int end = text.indexOf("</body>", textBegin);
        if (end == -1 && (end = text.indexOf("</html>", textBegin)) == -1) {
            end = text.length();
        }
        return text.substring(textBegin, end).trim();
    }

    public static String getURLOfExistingLink(HTMLDocument doc, int pos) {
        boolean foundLink;
        Element linkElement = HtmlUtils.getCurrentLinkElement(doc, pos);
        boolean bl = foundLink = linkElement != null;
        if (!foundLink) {
            return null;
        }
        AttributeSet elemAttrs = linkElement.getAttributes();
        Object linkAttr = elemAttrs.getAttribute(HTML.Tag.A);
        Object href = ((AttributeSet)linkAttr).getAttribute(HTML.Attribute.HREF);
        return href != null ? href.toString() : null;
    }

    public static Element getCurrentLinkElement(HTMLDocument doc, int pos) {
        Element element2 = null;
        Object linkAttribute = null;
        Object href = null;
        for (Element element = doc.getCharacterElement(pos); element != null && linkAttribute == null; element = element.getParentElement()) {
            element2 = element;
            linkAttribute = element.getAttributes().getAttribute(HTML.Tag.A);
            if (linkAttribute == null) continue;
            href = ((AttributeSet)linkAttribute).getAttribute(HTML.Attribute.HREF);
        }
        if (linkAttribute != null && href != null) {
            return element2;
        }
        return null;
    }

    public static boolean isEmpty(String newText) {
        return !newText.contains("<img") && !newText.contains("<table") && HtmlUtils.htmlToPlain(newText).equals("");
    }

    public static String toHTMLEscapedText(String s) {
        return HtmlUtils.toXMLEscapedText(s).replaceAll("\n", "<br>\n");
    }

    static {
        sInstance = new HtmlUtils();
        SLASHED_TAGS_PATTERN = Pattern.compile("<((br|area|base|basefont|bgsound|button|col|colgroup|embed|hr|img|input|isindex|keygen|link|meta|object|plaintext|spacer|wbr)(\\s[^>]*)?)/>");
        TAGS_PATTERN = Pattern.compile("(?s)<[^><]*>");
    }

    static class HtmlReplacer {
        private ArrayList<IndexPair> splittedStringList;
        private String stringWithoutTags;

        HtmlReplacer() {
        }

        public String getReplaceResult(Pattern pattern, String replacement, String text) {
            this.initialize(text);
            Matcher matcher = pattern.matcher(this.stringWithoutTags);
            if (!matcher.find()) {
                return text;
            }
            StringBuilder sbResult = new StringBuilder();
            int pureTextPosition = 0;
            Iterator<IndexPair> indexPairs = this.splittedStringList.iterator();
            IndexPair pair = null;
            while (true) {
                int mStart = matcher.start();
                int mEnd = matcher.end();
                if (pair == null) {
                    pair = indexPairs.next();
                    while (pair.pureTextEnd <= mStart) {
                        if (pair.mIsTag || pureTextPosition <= pair.pureTextStart) {
                            sbResult.append(text, pair.originalStart, pair.originalEnd);
                        } else if (pureTextPosition <= pair.pureTextEnd) {
                            sbResult.append(text, pair.originalStart + pureTextPosition - pair.pureTextStart, pair.originalEnd);
                        }
                        pair = indexPairs.next();
                    }
                    if (pureTextPosition < pair.pureTextStart) {
                        pureTextPosition = pair.pureTextStart;
                    }
                }
                sbResult.append(text, pair.originalStart + pureTextPosition - pair.pureTextStart, pair.originalStart + mStart - pair.pureTextStart);
                this.appendReplacement(sbResult, matcher, replacement);
                pureTextPosition = mEnd;
                if (!matcher.find()) break;
                if (matcher.start() < pair.pureTextEnd) continue;
                if (mEnd < pair.pureTextEnd) {
                    sbResult.append(text, pair.originalStart + pureTextPosition - pair.pureTextStart, pair.originalEnd);
                    pureTextPosition = pair.pureTextEnd;
                }
                pair = null;
            }
            while (true) {
                if (pureTextPosition <= pair.pureTextEnd) {
                    sbResult.append(text, pair.originalStart + pureTextPosition - pair.pureTextStart, text.length());
                    return sbResult.toString();
                }
                if (pair.mIsTag) {
                    sbResult.append(text, pair.originalStart, pair.originalEnd);
                }
                pair = indexPairs.next();
            }
        }

        private void initialize(String text) {
            this.splittedStringList = new ArrayList();
            this.stringWithoutTags = null;
            StringBuffer sb = new StringBuffer();
            Matcher matcher = FIND_TAGS_PATTERN.matcher(text);
            int lastMatchEnd = 0;
            while (matcher.find()) {
                IndexPair indexPair;
                String textWithoutTag = matcher.group(1);
                int replStart = sb.length();
                matcher.appendReplacement(sb, "$1");
                if (textWithoutTag.length() > 0) {
                    indexPair = new IndexPair(lastMatchEnd, matcher.end(1), replStart, sb.length(), false);
                    lastMatchEnd = matcher.end(1);
                    this.splittedStringList.add(indexPair);
                }
                replStart = sb.length();
                indexPair = new IndexPair(lastMatchEnd, matcher.end(2), sb.length(), sb.length(), true);
                lastMatchEnd = matcher.end(2);
                this.splittedStringList.add(indexPair);
            }
            int replStart = sb.length();
            matcher.appendTail(sb);
            if (sb.length() != replStart) {
                IndexPair indexPair = new IndexPair(lastMatchEnd, text.length(), replStart, sb.length(), false);
                this.splittedStringList.add(indexPair);
            }
            this.stringWithoutTags = sb.toString();
        }

        private void appendReplacement(StringBuilder sbResult, Matcher matcher, String replacement) {
            int cursor = 0;
            while (cursor < replacement.length()) {
                char nextChar = replacement.charAt(cursor);
                if (nextChar == '\\') {
                    nextChar = replacement.charAt(++cursor);
                    sbResult.append(nextChar);
                    ++cursor;
                    continue;
                }
                if (nextChar == '$') {
                    int nextDigit;
                    int refNum;
                    if ((refNum = replacement.charAt(++cursor) - 48) < 0 || refNum > 9) {
                        throw new IllegalArgumentException("Illegal group reference");
                    }
                    ++cursor;
                    boolean done = false;
                    while (!done && cursor < replacement.length() && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                        int newRefNum = refNum * 10 + nextDigit;
                        if (matcher.groupCount() < newRefNum) {
                            done = true;
                            continue;
                        }
                        refNum = newRefNum;
                        ++cursor;
                    }
                    if (matcher.group(refNum) == null) continue;
                    sbResult.append(matcher.group(refNum));
                    continue;
                }
                sbResult.append(nextChar);
                ++cursor;
            }
        }
    }

    public static class IndexPair {
        public final boolean mIsTag;
        public final int originalEnd;
        public final int originalStart;
        public final int pureTextEnd;
        public final int pureTextStart;

        public IndexPair(int pOriginalStart, int pOriginalEnd, int pPureTextStart, int pPureTextEnd, boolean pIsTag) {
            this.originalStart = pOriginalStart;
            this.originalEnd = pOriginalEnd;
            this.pureTextStart = pPureTextStart;
            this.pureTextEnd = pPureTextEnd;
            this.mIsTag = pIsTag;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[IndexPair:");
            buffer.append(" originalStart: ");
            buffer.append(this.originalStart);
            buffer.append(" originalEnd: ");
            buffer.append(this.originalEnd);
            buffer.append(" pureTextStart: ");
            buffer.append(this.pureTextStart);
            buffer.append(" pureTextEnd: ");
            buffer.append(this.pureTextEnd);
            buffer.append(" is a tag: ");
            buffer.append(this.mIsTag);
            buffer.append("]");
            return buffer.toString();
        }
    }
}

