/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeplaneVersion
implements Comparable<FreeplaneVersion> {
    private static final FreeplaneVersion VERSION = FreeplaneVersion.loadVersion();
    public static final String VERSION_KEY = "freeplane_version";
    public static final String VERSION_PROPERTIES = "/version.properties";
    public static final String XML_VERSION = "freeplane 1.3.0";
    private final int mMaj;
    private final int mMid;
    private final int mMin;
    private final int mNum;
    private String mType;
    private final String revision;

    public static FreeplaneVersion getVersion() {
        return VERSION;
    }

    public static FreeplaneVersion getVersion(String pString) throws IllegalArgumentException {
        if (pString == null) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(pString, "v. ", false);
        String[] info = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            info[i++] = t.nextToken();
        }
        if (info.length < 2 | info.length > 5) {
            throw new IllegalArgumentException("Wrong number of tokens for version information: " + pString);
        }
        try {
            int maj = Integer.parseInt(info[0]);
            int mid = Integer.parseInt(info[1]);
            int min = info.length < 3 ? 0 : Integer.parseInt(info[2]);
            String type = info.length < 4 ? "" : info[3];
            int num = info.length < 5 ? 0 : Integer.parseInt(info[4]);
            return new FreeplaneVersion(maj, mid, min, type, num, FreeplaneVersion.loadRevision());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong version token: " + pString, e);
        }
    }

    private static FreeplaneVersion loadVersion() {
        Properties versionProperties = FileUtils.loadProperties(VERSION_PROPERTIES);
        String versionString = versionProperties.getProperty(VERSION_KEY);
        String versionStatus = versionProperties.getProperty("freeplane_version_status");
        FreeplaneVersion version = FreeplaneVersion.getVersion(versionString);
        version.mType = versionStatus;
        return version;
    }

    public int getMaj() {
        return this.mMaj;
    }

    public int getMid() {
        return this.mMid;
    }

    public int getMin() {
        return this.mMin;
    }

    public int getNum() {
        return this.mNum;
    }

    public String getType() {
        return this.mType;
    }

    public String getRevision() {
        return this.revision;
    }

    public FreeplaneVersion(int pMaj, int pMid, int pMin, String pType, int pNum, String revision) {
        this.mMaj = pMaj;
        this.mMid = pMid;
        this.mMin = pMin;
        this.mType = pType;
        this.mNum = pNum;
        this.revision = revision;
    }

    public FreeplaneVersion(int pMaj, int pMid, int pMin) {
        this(pMaj, pMid, pMin, "", 0, "");
    }

    @Override
    public int compareTo(FreeplaneVersion o) {
        if (this.mMaj < o.mMaj) {
            return -1;
        }
        if (this.mMaj > o.mMaj) {
            return 1;
        }
        if (this.mMid < o.mMid) {
            return -1;
        }
        if (this.mMid > o.mMid) {
            return 1;
        }
        if (this.mMin < o.mMin) {
            return -1;
        }
        if (this.mMin > o.mMin) {
            return 1;
        }
        if (this.mNum < o.mNum) {
            return -1;
        }
        if (this.mNum > o.mNum) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mMaj);
        buf.append('.');
        buf.append(this.mMid);
        buf.append('.');
        buf.append(this.mMin);
        if (!this.mType.equals("")) {
            buf.append(' ');
            buf.append(this.mType);
        }
        if (this.mNum != 0) {
            buf.append(' ');
            buf.append(this.mNum);
        }
        return buf.toString();
    }

    public String numberToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mMaj);
        buf.append('.');
        buf.append(this.mMid);
        buf.append('.');
        buf.append(this.mMin);
        return buf.toString();
    }

    public boolean isOlderThan(FreeplaneVersion freeplaneVersion) {
        return this.compareTo(freeplaneVersion) < 0;
    }

    public boolean isNewerThan(FreeplaneVersion freeplaneVersion) {
        return this.compareTo(freeplaneVersion) > 0;
    }

    public boolean isFinal() {
        return "".equals(this.mType);
    }

    private static String loadRevision() {
        String revision;
        URL gitInfo = ResourceController.getResourceController().getResource("/gitinfo.properties");
        if (gitInfo != null) {
            Properties gitProps = new Properties();
            try {
                gitProps.load(gitInfo.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            revision = gitProps.getProperty("git-revision", "");
        } else {
            revision = "";
        }
        return revision;
    }
}

