/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromURL(URL resource, File destinationDirectory) {
        String path = resource.getPath();
        int index = path.lastIndexOf(47);
        String fileName = index > -1 ? path.substring(index + 1) : path;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = resource.openStream();
            out = new FileOutputStream(new File(destinationDirectory, fileName));
            FileUtils.copyStream(in, out);
        }
        catch (Exception e) {
            try {
                LogUtils.severe("File not found or could not be copied. Was searching for " + path + " and should go to " + destinationDirectory.getAbsolutePath());
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(in, out);
                throw throwable;
            }
            FileUtils.silentlyClose(in, out);
        }
        FileUtils.silentlyClose(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromResource(String path, String fileName, File destinationDirectory) {
        URL resource;
        FileOutputStream out;
        BufferedInputStream in;
        String pathToResource;
        block5: {
            pathToResource = path + fileName;
            in = null;
            out = null;
            resource = pathToResource.startsWith("file:") ? new URL(pathToResource) : ResourceController.getResourceController().getResource(pathToResource);
            if (resource != null) break block5;
            LogUtils.severe("Cannot find resource: " + pathToResource);
            FileUtils.silentlyClose(in, out);
            return;
        }
        try {
            in = new BufferedInputStream(resource.openStream());
            out = new FileOutputStream(new File(destinationDirectory, fileName));
            FileUtils.copyStream(in, out);
        }
        catch (Exception e) {
            try {
                LogUtils.severe("File not found or could not be copied. Was searching for " + pathToResource + " and should go to " + destinationDirectory.getAbsolutePath());
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(in, out);
                throw throwable;
            }
            FileUtils.silentlyClose(in, out);
        }
        FileUtils.silentlyClose(in, out);
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStringToFile(String string, File outFile, String encoding) throws IOException {
        FileOutputStream outStream = null;
        OutputStreamWriter out = null;
        try {
            outStream = new FileOutputStream(outFile);
            out = new OutputStreamWriter((OutputStream)outStream, encoding);
            out.write(string);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean createDirectory(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    public static Properties loadProperties(String classpathRessource) {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = FileUtils.class.getResource(classpathRessource).openStream();
            props.load(in);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(in);
                throw throwable;
            }
        }
        FileUtils.silentlyClose(in);
        return props;
    }

    private static String slurp(Reader reader) throws IOException {
        int len;
        StringBuilder builder = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) > 0) {
            builder.append(buf, 0, len);
        }
        String result = builder.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurpResource(URL resource) throws IOException {
        InputStream instream = null;
        try {
            instream = resource.openStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(instream));
            String string = FileUtils.slurp(input);
            return string;
        }
        finally {
            if (instream != null) {
                instream.close();
            }
        }
    }

    public static String slurpResource(String fileName) throws IOException {
        URL resource = ResourceController.getResourceController().getResource(fileName);
        if (resource == null) {
            LogUtils.severe("Cannot find resource: " + fileName);
            return "";
        }
        return FileUtils.slurpResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurpFile(File file) throws IOException {
        FileReader in = null;
        try {
            in = new FileReader(file);
            String string = FileUtils.slurp(in);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String slurpFile(String fileName) throws IOException {
        return FileUtils.slurpFile(new File(fileName));
    }

    public static Charset defaultCharset() {
        try {
            String defaultCharsetName = ResourceController.getResourceController().getProperty("default_charset");
            if (defaultCharsetName.equals("JVMdefault")) {
                return Charset.defaultCharset();
            }
            return Charset.forName(defaultCharsetName);
        }
        catch (Exception e) {
            return Charset.defaultCharset();
        }
    }

    public static String getExtension(File f) {
        return FileUtils.getExtension(f.toString());
    }

    public static String getExtension(String s) {
        if (s == null) {
            return null;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c == File.separatorChar || c == '/') {
                return "";
            }
            if (c != '.') continue;
            return s.substring(i + 1).trim().toLowerCase();
        }
        return "";
    }

    public static boolean isAbsolutePath(String path) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        String fileSeparator = System.getProperty("file.separator");
        if (osNameStart.equals("Win")) {
            return path.length() > 1 && path.substring(1, 2).equals(":") || path.startsWith(fileSeparator);
        }
        if (osNameStart.equals("Mac")) {
            return path.startsWith(fileSeparator);
        }
        return path.startsWith(fileSeparator);
    }

    public static String readFile(File pInputFile) {
        StringBuilder lines = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(pInputFile));
            String endLine = System.getProperty("line.separator");
            while ((line = bufferedReader.readLine()) != null) {
                lines.append(line).append(endLine);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception ex) {
                    LogUtils.severe(ex);
                }
            }
            return null;
        }
        return lines.toString();
    }

    public static String removeExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(0, i) : s;
    }

    public static void setHidden(File file, boolean hidden, boolean synchronously) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win")) {
            try {
                Controller.exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
                if (!synchronously) {
                    return;
                }
                for (int timeOut = 10; file.isHidden() != hidden && timeOut > 0; --timeOut) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
    }

    public static void silentlyClose(Closeable ... streams) {
        for (Closeable stream : streams) {
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (IOException e) {
                LogUtils.severe(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            int maxCount = 67076096;
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, maxCount, outChannel)) {
            }
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

