/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUtils {
    private static final String CONFIG_LIST_VALUE_SEPARATOR_STRICT = File.pathSeparator + File.pathSeparator;
    private static final String CONFIG_LIST_VALUE_SEPARATOR_ONE_OR_MORE = File.pathSeparator + '+';

    public static List<String> decodeListValue(String value, boolean requireTwo) {
        if (value.length() == 0) {
            return Collections.emptyList();
        }
        String sep = requireTwo ? CONFIG_LIST_VALUE_SEPARATOR_STRICT : CONFIG_LIST_VALUE_SEPARATOR_ONE_OR_MORE;
        return Arrays.asList(value.split("\\s*" + sep + "\\s*"));
    }

    public static String encodeListValue(List<String> list, boolean requireTwo) {
        return StringUtils.join(list.iterator(), (String)(requireTwo ? CONFIG_LIST_VALUE_SEPARATOR_STRICT : CONFIG_LIST_VALUE_SEPARATOR_ONE_OR_MORE));
    }

    public static File getLocalizedFile(File[] baseDirs, String document, String languageCode) {
        int extPosition = document.lastIndexOf(46);
        String localizedDocument = extPosition != -1 ? document.substring(0, extPosition) + "_" + languageCode + document.substring(extPosition) : document;
        for (File baseDir : baseDirs) {
            if (baseDir == null) continue;
            File localFile = new File(baseDir, localizedDocument);
            if (localFile.canRead()) {
                return localFile;
            }
            File file = new File(baseDir, document);
            if (!file.canRead()) continue;
            return file;
        }
        return null;
    }
}

