/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.util.FileUtils;
import org.freeplane.features.mode.Controller;

public class Compat {
    public static final String PROPERTY_FREEPLANE_USERDIR = "org.freeplane.userfpdir";
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String VERSION_1_6_0 = "1.6.0";
    private static OS os = null;
    public static final Set<String> executableExtensions = new HashSet<String>(Arrays.asList("exe", "com", "vbs", "bat", "lnk", "cmd"));
    private static final String CURRENT_VERSION_DIR = File.separatorChar + "1.3.x";

    public static boolean isWindowsExecutable(URI link) {
        if (link == null || !"file".equalsIgnoreCase(link.getScheme())) {
            return false;
        }
        return Compat.isWindowsOS() && executableExtensions.contains(FileUtils.getExtension(link.toString()));
    }

    public static URL fileToUrl(File pFile) throws MalformedURLException {
        return pFile.toURL();
    }

    public static boolean isLowerJdk(String version) {
        return JAVA_VERSION.compareTo(version) < 0;
    }

    public static boolean isMacOsX() {
        Compat.initOS();
        return os.equals((Object)OS.MAC);
    }

    private static void initOS() {
        if (os == null) {
            String debugOsName;
            String osProperty;
            try {
                osProperty = System.getProperty("os.name");
            }
            catch (SecurityException e) {
                osProperty = "";
            }
            try {
                debugOsName = System.getProperty("freeplane.debug.os.name", "");
            }
            catch (SecurityException e) {
                debugOsName = "";
            }
            if (osProperty.startsWith("Mac OS") || debugOsName.startsWith("Mac")) {
                os = OS.MAC;
                return;
            }
            if (osProperty.startsWith("Windows") || debugOsName.startsWith("Windows")) {
                os = OS.WINDOWS;
                return;
            }
            os = OS.OTHER;
        }
    }

    public static boolean isWindowsOS() {
        Compat.initOS();
        return os.equals((Object)OS.WINDOWS);
    }

    private static String urlGetFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String fileName = url.toString().replaceFirst("^file:", "");
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win") && url.getProtocol().equals("file")) {
            return (fileName = fileName.replace('/', File.separatorChar)).indexOf(58) >= 0 ? fileName.replaceFirst("^\\\\*", "") : fileName;
        }
        return fileName;
    }

    public static File urlToFile(URL pUrl) throws URISyntaxException {
        String path = Compat.urlGetFile(pUrl);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public static void macAppChanges() {
        if (!Compat.isMacOsX()) {
            return;
        }
        try {
            Class<?> macChanges = Controller.class.getClassLoader().loadClass("org.freeplane.plugin.macos.MacChanges");
            Method method = macChanges.getMethod("apply", Controller.class);
            method.invoke(null, Controller.getCurrentController());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fixMousePointerForLinux() {
        if (Compat.isX11WindowManager()) {
            try {
                Class<?> xwm = Class.forName("sun.awt.X11.XWM");
                Field awt_wmgr = xwm.getDeclaredField("awt_wmgr");
                awt_wmgr.setAccessible(true);
                Field other_wm = xwm.getDeclaredField("OTHER_WM");
                other_wm.setAccessible(true);
                if (awt_wmgr.get(null).equals(other_wm.get(null))) {
                    Field metacity_wm = xwm.getDeclaredField("METACITY_WM");
                    metacity_wm.setAccessible(true);
                    awt_wmgr.set(null, metacity_wm.get(null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isX11WindowManager() {
        return Arrays.asList("gnome-shell", "mate", "other...").contains(System.getenv("DESKTOP_SESSION"));
    }

    public static void macMenuChanges() {
        if (!Compat.isMacOsX()) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        Set<String> modes = controller.getModes();
        for (String mode : modes) {
            String[] keys;
            MenuBuilder builder = controller.getModeController(mode).getUserInputListenerFactory().getMenuBuilder();
            for (String key : keys = new String[]{"MB_ToggleMenubarAction", "MP_ToggleMenubarAction", "MB_QuitAction", "MB_PropertyAction", "MB_AboutAction"}) {
                if (!builder.contains(key)) continue;
                builder.removeElement(key);
            }
        }
    }

    public static String getFreeplaneUserDirectory() {
        String userFpDir = System.getProperty(PROPERTY_FREEPLANE_USERDIR);
        if (userFpDir == null) {
            userFpDir = Compat.getDefaultFreeplaneUserDirectory();
        }
        return userFpDir + CURRENT_VERSION_DIR;
    }

    private static String getDefaultFreeplaneUserDirectory() {
        return System.getProperty("user.home") + File.separator + ".freeplane";
    }

    public static String smbUri2unc(URI uri) {
        String uriString = ("//" + uri.getHost() + uri.getPath()).replace('/', '\\');
        String fragment = uri.getFragment();
        if (fragment != null) {
            uriString = uriString + '#' + fragment;
        }
        return uriString;
    }

    public static boolean isPlainEvent(MouseEvent e) {
        int modifiers = Compat.getModifiers(e);
        return modifiers == 0;
    }

    private static int getModifiers(MouseEvent e) {
        return e.getModifiersEx() & 0x3C0;
    }

    public static boolean isCtrlEvent(MouseEvent e) {
        return Compat.isExtendedCtrlEvent(e, 0);
    }

    public static boolean isCtrlShiftEvent(MouseEvent e) {
        return Compat.isExtendedCtrlEvent(e, 64);
    }

    public static boolean isCtrlAltEvent(MouseEvent e) {
        return Compat.isExtendedCtrlEvent(e, 512);
    }

    private static boolean isExtendedCtrlEvent(MouseEvent e, int otherModifiers) {
        int modifiers = Compat.getModifiers(e);
        if (Compat.isMacOsX()) {
            return modifiers == (0x100 | otherModifiers);
        }
        return modifiers == (0x80 | otherModifiers);
    }

    public static boolean isShiftEvent(MouseEvent e) {
        int modifiers = Compat.getModifiers(e);
        return modifiers == 64;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OS {
        MAC,
        WINDOWS,
        OTHER;

    }
}

