/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.undo;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.undo.CompoundActor;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;

public class UndoHandler
implements IUndoHandler {
    private final List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    public static final int COMMIT_DELAY = 2;
    private static final int MAX_ENTRIES = 100;
    private static final long TIME_TO_BEGIN_NEW_ACTION = 100L;
    private boolean actionFrameStarted = false;
    private ListIterator<IActor> actorIterator;
    private ActorList actorList = new ActorList();
    private boolean isUndoActionRunning = false;
    private final ActionListener redoAction;
    private long timeOfLastAdd = 0L;
    private final LinkedList<ActorList> transactionList = new LinkedList();
    private final LinkedList<ListIterator<IActor>> transactionIteratorList = new LinkedList();
    private final ActionListener undoAction;
    private boolean deactivated = false;
    private final ChangeEvent event;

    public UndoHandler() {
        this.actorIterator = this.actorList.listIterator();
        this.redoAction = new RedoAction();
        this.undoAction = new UndoAction();
        this.event = new ChangeEvent(this);
    }

    public void deactivate() {
        this.deactivated = true;
        this.fireStateChanged();
        this.startActionFrame();
    }

    public void addActor(IActor actor) {
        this.resetRedo();
        this.actorList.commitDelay = 2;
        long currentTime = System.currentTimeMillis();
        if (this.deactivated) {
            if (!this.actionFrameStarted && currentTime - this.timeOfLastAdd > 100L) {
                this.deactivated = false;
            } else {
                if (this.actorList.size() > 0) {
                    this.actorList.clear();
                    this.actorIterator = this.actorList.listIterator();
                }
                return;
            }
        }
        if (this.actorList.size() > 0 && (this.actionFrameStarted || currentTime - this.timeOfLastAdd < 100L)) {
            CompoundActor compoundActor;
            IActor lastActor = this.actorIterator.previous();
            if (!(lastActor instanceof CompoundActor)) {
                compoundActor = new CompoundActor();
                compoundActor.add(lastActor);
                this.actorIterator.set(compoundActor);
            } else {
                compoundActor = (CompoundActor)lastActor;
            }
            compoundActor.add(actor);
            this.actorIterator.next();
        } else {
            this.actorIterator.add(actor);
            int maxEntries = 100;
            while (this.actorList.size() > 100) {
                this.actorList.removeFirst();
                this.actorIterator = this.actorList.listIterator(this.actorList.size());
            }
        }
        this.startActionFrame();
        this.timeOfLastAdd = currentTime;
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(this.event);
        }
    }

    public boolean canRedo() {
        return this.actorIterator.hasNext();
    }

    public boolean canUndo() {
        return this.actorIterator.hasPrevious();
    }

    public void commit() {
        this.resetRedo();
        CompoundActor compoundActor = new CompoundActor(this.actorList);
        this.actionFrameStarted = false;
        this.timeOfLastAdd = 0L;
        if (this.transactionList.isEmpty()) {
            LogUtils.warn("transactionList is empty on UndoHandler.commit()");
            return;
        }
        this.actorList = this.transactionList.removeLast();
        this.actorIterator = this.transactionIteratorList.removeLast();
        if (!compoundActor.isEmpty()) {
            this.addActor(compoundActor);
            this.actionFrameStarted = false;
            this.timeOfLastAdd = 0L;
        } else {
            this.fireStateChanged();
        }
    }

    public void delayedCommit() {
        if (this.actorList.commitDelay == 0) {
            this.commit();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                --((UndoHandler)UndoHandler.this).actorList.commitDelay;
                UndoHandler.this.delayedCommit();
            }
        });
    }

    public void delayedRollback() {
        if (this.actorList.commitDelay == 0) {
            this.rollback();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                --((UndoHandler)UndoHandler.this).actorList.commitDelay;
                UndoHandler.this.delayedRollback();
            }
        });
    }

    public String getLastDescription() {
        String description = this.canUndo() ? ((IActor)this.actorList.getLast()).getDescription() : null;
        return description;
    }

    public ActionListener getRedoAction() {
        return this.redoAction;
    }

    public ActionListener getUndoAction() {
        return this.undoAction;
    }

    public boolean isUndoActionRunning() {
        return this.isUndoActionRunning;
    }

    public void redo() {
        if (this.canRedo()) {
            IActor redoActor = this.actorIterator.next();
            this.isUndoActionRunning = true;
            redoActor.act();
            this.isUndoActionRunning = false;
            this.fireStateChanged();
        }
    }

    public void resetRedo() {
        while (this.canRedo()) {
            this.actorIterator.next();
            this.actorIterator.remove();
        }
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            this.isUndoActionRunning = true;
            while (this.actorIterator.hasPrevious()) {
                IActor actor = this.actorIterator.previous();
                actor.undo();
            }
        }
        finally {
            this.isUndoActionRunning = false;
        }
        if (this.transactionList.isEmpty()) {
            LogUtils.warn("transactionList is empty on UndoHandler.rollback()");
            return;
        }
        this.actorList = this.transactionList.removeLast();
        this.actorIterator = this.transactionIteratorList.removeLast();
        this.fireStateChanged();
    }

    private void startActionFrame() {
        ViewController viewController;
        if (!this.actionFrameStarted && (viewController = Controller.getCurrentController().getViewController()).isDispatchThread()) {
            this.actionFrameStarted = true;
            viewController.invokeLater(new Runnable(){

                public void run() {
                    UndoHandler.this.actionFrameStarted = false;
                }
            });
        }
    }

    public void forceNewTransaction() {
        this.timeOfLastAdd = 0L;
        this.actionFrameStarted = false;
    }

    public void startTransaction() {
        ActorList newActorList;
        this.transactionList.addLast(this.actorList);
        this.transactionIteratorList.addLast(this.actorIterator);
        this.actorList = newActorList = new ActorList();
        this.actorIterator = newActorList.listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.canUndo()) {
            IActor actor = this.actorIterator.previous();
            try {
                this.isUndoActionRunning = true;
                actor.undo();
            }
            finally {
                this.isUndoActionRunning = false;
                this.fireStateChanged();
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public int getTransactionLevel() {
        return this.transactionList.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActorList
    extends LinkedList<IActor> {
        private static final long serialVersionUID = 1L;
        int commitDelay = 2;

        private ActorList() {
        }
    }

    private class UndoAction
    implements ActionListener {
        private UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            UndoHandler.this.undo();
        }
    }

    private class RedoAction
    implements ActionListener {
        private RedoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            UndoHandler.this.redo();
        }
    }
}

