/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.UITools;

public class ScaledStyleSheet
extends StyleSheet {
    private static final long serialVersionUID = 1L;

    public Font getFont(AttributeSet a) {
        Font font = super.getFont(a);
        float fontScaleFactor = this.getFontScaleFactor(a);
        return super.getFont(font.getFamily(), font.getStyle(), Math.round(font.getSize2D() * fontScaleFactor));
    }

    private float getFontScaleFactor(AttributeSet a) {
        Object attribute = a.getAttribute(CSS.Attribute.FONT_SIZE);
        if (attribute == null) {
            return UITools.FONT_SCALE_FACTOR;
        }
        String fontSize = attribute.toString();
        int fsLength = fontSize.length();
        if (fsLength <= 1 || Character.isDigit(fontSize.charAt(fsLength - 1)) || fontSize.endsWith("pt")) {
            return UITools.FONT_SCALE_FACTOR;
        }
        if (fontSize.endsWith("px")) {
            return 0.7692308f;
        }
        if (fontSize.endsWith("%") || fontSize.endsWith("em") || fontSize.endsWith("ex") || fontSize.endsWith("er")) {
            return this.getFontScaleFactor(a.getResolveParent());
        }
        return UITools.FONT_SCALE_FACTOR;
    }
}

