/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import org.freeplane.core.ui.components.html.ScaledEditorKit;

public class ScaledHTML
extends BasicHTML {
    static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }";

    public static View createHTMLView(JComponent c, String html) {
        ScaledEditorKit kit = ScaledEditorKit.create();
        Document doc = kit.createDefaultDocument(c.getFont(), c.getForeground());
        Object base = c.getClientProperty("html.base");
        if (base instanceof URL) {
            ((HTMLDocument)doc).setBase((URL)base);
        }
        StringReader r = new StringReader(html);
        try {
            kit.read(r, doc, 0);
        }
        catch (Throwable e) {
            // empty catch block
        }
        ViewFactory f = kit.getViewFactory();
        View hview = f.create(doc.getDefaultRootElement());
        Renderer v = new Renderer(c, f, hview);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRenderer(JComponent c, String text) {
        View value = null;
        try {
            View oldValue = (View)c.getClientProperty("html");
            if (ScaledHTML.isHTMLString(text)) {
                value = ScaledHTML.createHTMLView(c, text);
            }
            if (value != oldValue && oldValue != null) {
                for (int i = 0; i < oldValue.getViewCount(); ++i) {
                    oldValue.getView(i).setParent(null);
                }
            }
            c.putClientProperty("html", value);
        }
        catch (Throwable throwable) {
            c.putClientProperty("html", value);
            throw throwable;
        }
    }

    public static class Renderer
    extends View {
        private int width;
        private View view;
        private ViewFactory factory;
        private JComponent host;
        private boolean setSizeRunning = true;

        Renderer(JComponent c, ViewFactory f, View v) {
            super(null);
            this.host = c;
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(axis);
        }

        public float getMinimumSpan(int axis) {
            return this.view.getMinimumSpan(axis);
        }

        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View child, boolean width, boolean height) {
            if (!this.setSizeRunning) {
                this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
            }
            this.host.revalidate();
            this.host.repaint();
        }

        public float getAlignment(int axis) {
            return this.view.getAlignment(axis);
        }

        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this.view.setSize(alloc.width, alloc.height);
            this.view.paint(g, allocation);
        }

        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return this.view.modelToView(pos, a, b);
        }

        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            return this.view.modelToView(p0, b0, p1, b1, a);
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return this.view.viewToModel(x, y, a, bias);
        }

        public Document getDocument() {
            return this.view.getDocument();
        }

        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        public Element getElement() {
            return this.view.getElement();
        }

        public void setSize(float width, float height) {
            this.setSizeRunning = true;
            this.width = (int)width;
            this.view.setSize(width, height);
            this.setSizeRunning = false;
        }

        public void resetSize() {
            this.setSize(0.0f, 0.0f);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        public Container getContainer() {
            return this.host;
        }

        public ViewFactory getViewFactory() {
            return this.factory;
        }
    }
}

