/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Color;
import java.awt.Font;
import java.io.StringReader;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.ScaledStyleSheet;
import org.freeplane.core.util.ColorUtils;

public class ScaledEditorKit
extends HTMLEditorKit {
    private static StyleSheet defaultStyles;
    private static ScaledEditorKit kit;

    protected ScaledEditorKit() {
    }

    public StyleSheet getStyleSheet() {
        if (defaultStyles == null) {
            defaultStyles = new StyleSheet();
            StringReader r = new StringReader("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }");
            try {
                defaultStyles.loadRules(r, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            r.close();
            defaultStyles.addStyleSheet(super.getStyleSheet());
        }
        return defaultStyles;
    }

    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        ScaledStyleSheet ss = new ScaledStyleSheet();
        ss.addStyleSheet(styles);
        HTMLDocument doc = new HTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    Document createDefaultDocument(Font defaultFont, Color foreground) {
        StyleSheet styles = this.getStyleSheet();
        ScaledStyleSheet ss = new ScaledStyleSheet();
        ss.addStyleSheet(styles);
        HTMLDocument doc = new HTMLDocument(ss);
        doc.setPreservesUnknownTags(false);
        doc.getStyleSheet().addRule(this.displayPropertiesToCSS(defaultFont, foreground));
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        doc.setPreservesUnknownTags(false);
        return doc;
    }

    private String displayPropertiesToCSS(Font font, Color fg) {
        StringBuffer rule = new StringBuffer("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            int fontSize = Math.round((float)font.getSize() / UITools.FONT_SCALE_FACTOR);
            rule.append(fontSize);
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: bold ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: ").append(ColorUtils.colorToString(fg)).append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static ScaledEditorKit create() {
        if (kit == null) {
            kit = new ScaledEditorKit();
        }
        return kit;
    }
}

