/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.calendar;

import java.util.Calendar;
import javax.swing.JFrame;
import org.freeplane.core.ui.components.calendar.JDayChooser;
import org.freeplane.core.ui.components.calendar.JSpinField;

public class JYearChooser
extends JSpinField {
    private static final long serialVersionUID = 1L;
    public static final String YEAR_PROPERTY = "year";
    protected JDayChooser dayChooser;
    protected int endYear;
    protected int oldYear;
    protected int startYear;

    public static void main(String[] s) {
        JFrame frame = new JFrame("JYearChooser");
        frame.getContentPane().add(new JYearChooser());
        frame.pack();
        frame.setVisible(true);
    }

    public JYearChooser() {
        this.setName("JYearChooser");
        Calendar calendar = Calendar.getInstance();
        this.dayChooser = null;
        this.setMinimum(calendar.getMinimum(1));
        this.setMaximum(calendar.getMaximum(1));
        this.setValue(calendar.get(1));
    }

    public int getEndYear() {
        return this.getMaximum();
    }

    public int getStartYear() {
        return this.getMinimum();
    }

    public int getYear() {
        return super.getValue();
    }

    public void setDayChooser(JDayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    public void setEndYear(int endYear) {
        this.setMaximum(endYear);
    }

    public void setStartYear(int startYear) {
        this.setMinimum(startYear);
    }

    public void setValue(int value) {
        this.setYear(value);
    }

    public void setYear(int y) {
        super.setValue(y, true, false);
        if (this.dayChooser != null) {
            this.dayChooser.setYear(this.value);
        }
        this.spinner.setValue(new Integer(this.value));
        this.firePropertyChange(YEAR_PROPERTY, this.oldYear, this.value);
        this.oldYear = this.value;
    }
}

