/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.UrlManager;
import org.freeplane.main.application.FreeplaneSplashModern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UITools {
    public static final String MAIN_FREEPLANE_FRAME = "mainFreeplaneFrame";
    public static final String SCROLLBAR_INCREMENT = "scrollbar_increment";
    public static final Dimension MAX_BUTTON_DIMENSION = new Dimension(1000, 1000);
    public static final float FONT_SCALE_FACTOR;

    public static void addEscapeActionToDialog(JDialog dialog) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EscapeAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ JDialog val$dialog;

            EscapeAction(JDialog jDialog) {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
            }
        }
        UITools.addEscapeActionToDialog(dialog, new EscapeAction(dialog));
    }

    public static void addEscapeActionToDialog(JDialog dialog, Action action) {
        UITools.addKeyActionToDialog(dialog, action, "ESCAPE", "end_dialog");
    }

    public static void addKeyActionToDialog(JDialog dialog, Action action, String keyStroke, String actionId) {
        action.putValue("Name", actionId);
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public static void convertPointFromAncestor(Component ancestor, Point p, Component c) {
        while (c != ancestor && c != null) {
            int x = c.getX();
            int y = c.getY();
            p.x -= x;
            p.y -= y;
            c = c.getParent();
        }
    }

    public static void convertPointToAncestor(Component source, Point point, Class<?> ancestorClass) {
        Container destination = SwingUtilities.getAncestorOfClass(ancestorClass, source);
        UITools.convertPointToAncestor(source, point, destination);
    }

    public static void convertRectangleToAncestor(Component from, Rectangle r, Component destination) {
        Point p = new Point(r.x, r.y);
        UITools.convertPointToAncestor(from, p, destination);
        r.x = p.x;
        r.y = p.y;
    }

    public static void convertPointToAncestor(Component from, Point p, Component destination) {
        for (Component c = from; c != destination && c != null; c = c.getParent()) {
            int x = c.getX();
            int y = c.getY();
            p.x += x;
            p.y += y;
        }
    }

    public static void errorMessage(Object message) {
        final String myMessage = message != null ? message.toString() : TextUtils.getText("undefined_error");
        LogUtils.warn(myMessage);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(UITools.getFrame(), myMessage, "Freeplane", 0);
            }
        });
    }

    public static Frame getFrame() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            if (!MAIN_FREEPLANE_FRAME.equals(frame.getName())) continue;
            return frame;
        }
        return frames.length >= 1 ? frames[0] : null;
    }

    public static KeyStroke getKeyStroke(String keyStrokeDescription) {
        if (keyStrokeDescription == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyStrokeDescription);
        if (keyStroke != null) {
            return keyStroke;
        }
        int lastSpacePos = keyStrokeDescription.lastIndexOf(32) + 1;
        String modifiedDescription = keyStrokeDescription.substring(0, lastSpacePos) + "typed " + keyStrokeDescription.substring(lastSpacePos);
        return KeyStroke.getKeyStroke(modifiedDescription);
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        String acceleratorText = "";
        if (keyStroke != null) {
            int modifiers = keyStroke.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + "+";
            }
            acceleratorText = acceleratorText + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return acceleratorText;
    }

    public static void informationMessage(String message) {
        UITools.informationMessage(UITools.getFrame(), message);
    }

    public static void informationMessage(Frame frame, String message) {
        UITools.informationMessage(frame, message, "Freeplane");
    }

    public static void informationMessage(Frame frame, String message, String title) {
        JOptionPane.showMessageDialog(frame, message, title, 1);
    }

    public static void informationMessage(Frame frame, String text, String string, int type) {
        JOptionPane.showMessageDialog(frame, text, string, type);
    }

    public static void setBounds(Component frame, int win_x, int win_y, int win_width, int win_height) {
        Rectangle desktopBounds = UITools.getDesktopBounds(frame);
        int screenWidth = desktopBounds.width;
        win_width = win_width != -1 ? Math.min(win_width, screenWidth) : screenWidth * 4 / 5;
        int screenHeight = desktopBounds.height;
        win_height = win_height != -1 ? Math.min(win_height, screenHeight) : screenHeight * 4 / 5;
        if (win_x != -1) {
            win_x = Math.min(screenWidth + desktopBounds.x - win_width, win_x);
            win_x = Math.max(desktopBounds.x, win_x);
        } else {
            win_x = desktopBounds.x + (screenWidth - win_width) / 2;
        }
        if (win_y != -1) {
            win_y = Math.max(desktopBounds.y, win_y);
            win_y = Math.min(screenHeight + desktopBounds.y - win_height, win_y);
        } else {
            win_y = desktopBounds.y + (screenHeight - win_height) / 2;
        }
        frame.setBounds(win_x, win_y, win_width, win_height);
    }

    public static Rectangle getDesktopBounds(Component frame) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Insets screenInsets = defaultToolkit.getScreenInsets(frame.getGraphicsConfiguration());
        Dimension screenSize = defaultToolkit.getScreenSize();
        int screenWidth = screenSize.width - screenInsets.left - screenInsets.right;
        int screenHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
        return new Rectangle(screenInsets.left, screenInsets.top, screenWidth, screenHeight);
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, Component c) {
        int bottomSpace;
        int topSpace;
        int rightSpace;
        int leftSpace;
        if (c == null || !c.isShowing()) {
            return;
        }
        Point compLocation = c.getLocationOnScreen();
        int cw = c.getWidth();
        int ch = c.getHeight();
        Container parent = dialog.getParent();
        Point parentLocation = parent.getLocationOnScreen();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int dw = dialog.getWidth();
        int dh = dialog.getHeight();
        Rectangle desktopBounds = UITools.getDesktopBounds(c);
        int minX = Math.max(parentLocation.x, desktopBounds.x);
        int minY = Math.max(parentLocation.y, desktopBounds.y);
        int maxX = Math.min(parentLocation.x + pw, desktopBounds.x + desktopBounds.width);
        int maxY = Math.min(parentLocation.y + ph, desktopBounds.y + desktopBounds.height);
        int dx = compLocation.x + cw < minX ? minX : (compLocation.x > maxX ? maxX - dw : ((leftSpace = compLocation.x - minX) > (rightSpace = maxX - (compLocation.x + cw)) ? (leftSpace > dw ? compLocation.x - dw : minX) : (rightSpace > dw ? compLocation.x + cw : maxX - dw)));
        int dy = compLocation.y + ch < minY ? minY : (compLocation.y > maxY ? maxY - dh : ((topSpace = compLocation.y - minY) > (bottomSpace = maxY - (compLocation.y + ch)) ? (topSpace > dh ? compLocation.y - dh : minY) : (bottomSpace > dh ? compLocation.y + ch : maxY - dh)));
        dialog.setLocation(dx, dy);
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, NodeModel node) {
        if (node == null) {
            return;
        }
        IMapViewManager viewController = Controller.getCurrentController().getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component c = viewController.getComponent(node);
        UITools.setDialogLocationRelativeTo(dialog, c);
    }

    public static void setDialogLocationUnder(JDialog dialog, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        JComponent c = (JComponent)viewController.getComponent(node);
        boolean x = false;
        int y = c.getHeight();
        Point location = new Point(0, y);
        SwingUtilities.convertPointToScreen(location, c);
        UITools.setBounds(dialog, location.x, location.y, dialog.getWidth(), dialog.getHeight());
    }

    public static void showAttributeEmptyStringErrorMessage() {
        JOptionPane.showMessageDialog(null, TextUtils.getText("attributes_adding_empty_attribute_error"), TextUtils.getText("error"), 0);
    }

    public static void showMessage(String message, int messageType) {
        UITools.backOtherWindows();
        JTextArea infoPane = new JTextArea();
        infoPane.setEditable(false);
        infoPane.setMargin(new Insets(5, 5, 5, 5));
        infoPane.setLineWrap(true);
        infoPane.setWrapStyleWord(true);
        infoPane.setText(message);
        infoPane.setColumns(60);
        JScrollPane scrollPane = new JScrollPane(infoPane);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        JOptionPane.showMessageDialog(UITools.getFrame(), scrollPane, "Freeplane", messageType);
    }

    public static int showConfirmDialog(NodeModel node, Object message, String title, int optionType, int messageType) {
        Component parentComponent;
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        if (node == null) {
            parentComponent = UITools.getFrame();
        } else {
            viewController.scrollNodeToVisible(node);
            parentComponent = viewController.getComponent(node);
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static int showConfirmDialog(NodeModel node, Object message, String title, int optionType) {
        return UITools.showConfirmDialog(node, message, title, optionType, 3);
    }

    public static String showInputDialog(NodeModel node, String message, String initialValue) {
        if (node == null) {
            return null;
        }
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component parentComponent = viewController.getComponent(node);
        return JOptionPane.showInputDialog(parentComponent, message, initialValue);
    }

    public static String showInputDialog(NodeModel node, String text, String title, int type) {
        if (node == null) {
            return null;
        }
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component parentComponent = viewController.getComponent(node);
        return JOptionPane.showInputDialog(parentComponent, text, title, type);
    }

    public static void setScrollbarIncrement(JScrollPane scrollPane) {
        int scrollbarIncrement = ResourceController.getResourceController().getIntProperty(SCROLLBAR_INCREMENT, 1);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
        scrollPane.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
    }

    public static void addScrollbarIncrementPropertyListener(final JScrollPane scrollPane) {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (!propertyName.equals(UITools.SCROLLBAR_INCREMENT)) {
                    return;
                }
                int scrollbarIncrement = Integer.valueOf(newValue);
                scrollPane.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
                scrollPane.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
            }
        });
    }

    public static Color getTextColorForBackground(Color color) {
        int red = color.getRed();
        int blue = color.getBlue();
        int green = color.getGreen();
        return red > 128 && blue > 128 && green > 128 ? Color.BLACK : Color.WHITE;
    }

    public static void focusOn(JComponent component) {
        component.addAncestorListener(new AncestorListener(){

            public void ancestorRemoved(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorAdded(AncestorEvent event) {
                final JComponent component = event.getComponent();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        component.requestFocus();
                    }
                });
                component.removeAncestorListener(this);
            }
        });
    }

    public static BasicStroke createStroke(int width, int[] dash) {
        float[] fdash;
        if (dash != null) {
            fdash = new float[dash.length];
            int i = 0;
            int[] arr$ = dash;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float d = arr$[i$];
                fdash[i++] = d;
            }
        } else {
            fdash = null;
        }
        BasicStroke stroke = new BasicStroke(width, 0, 1, 1.0f, fdash, 0.0f);
        return stroke;
    }

    public static void repaintAll(Container root) {
        root.repaint();
        for (int i = 0; i < root.getComponentCount(); ++i) {
            Component component = root.getComponent(i);
            if (component instanceof Container) {
                UITools.repaintAll((Container)component);
                continue;
            }
            component.repaint();
        }
    }

    public static JDialog createCancelDialog(Component component, String titel, String text) {
        Object[] options = new String[]{TextUtils.getText("cancel")};
        JOptionPane infoPane = new JOptionPane(text, -1, -1, null, options);
        JDialog dialog = infoPane.createDialog(component, titel);
        dialog.setModal(false);
        return dialog;
    }

    public static void addTitledBorder(JComponent c, String title, float size) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        Font titleFont = UIManager.getFont("TitledBorder.font");
        titledBorder.setTitleFont(titleFont.deriveFont(size));
        Border btnBorder = c.getBorder();
        if (btnBorder != null) {
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, btnBorder);
            c.setBorder(compoundBorder);
        } else {
            c.setBorder(titledBorder);
        }
    }

    public static void backOtherWindows() {
        Frame owner = UITools.getFrame();
        if (owner != null) {
            Window[] ownedWindows;
            for (Window w : ownedWindows = owner.getOwnedWindows()) {
                if (!w.isVisible()) continue;
                w.toBack();
            }
        }
    }

    public static JButton createHtmlLinkStyleButton(final URI uri, String title) {
        JButton button = new JButton("<html><a href='" + uri + "'>" + title);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setBackground(Color.lightGray);
        button.setFocusable(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModeController modeController = Controller.getCurrentModeController();
                UrlManager urlManager = modeController.getExtension(UrlManager.class);
                urlManager.loadURL(uri);
            }
        });
        return button;
    }

    public static final int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getScreenResolution() {
        int systemScreenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        if (ResourceController.getResourceController().getBooleanProperty("apply_system_screen_resolution")) {
            return systemScreenResolution;
        }
        return ResourceController.getResourceController().getIntProperty("user_defined_screen_resolution", systemScreenResolution);
    }

    public static Font scale(Font font) {
        return font.deriveFont(font.getSize2D() * FONT_SCALE_FACTOR);
    }

    public static Font invertScale(Font font) {
        return font.deriveFont(font.getSize2D() / FONT_SCALE_FACTOR);
    }

    public static void showFrame() {
        Frame frame = UITools.getFrame();
        Window[] ownedWindows = frame.getOwnedWindows();
        for (int i = 0; i < ownedWindows.length; ++i) {
            Window window = ownedWindows[i];
            if (!window.getClass().equals(FreeplaneSplashModern.class) || !window.isVisible()) continue;
            window.setVisible(false);
        }
        if (frame != null && !frame.isVisible()) {
            frame.setVisible(true);
            frame.toFront();
        }
    }

    static {
        float factor = 1.0f;
        try {
            factor = (float)UITools.getScreenResolution() / 72.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        FONT_SCALE_FACTOR = factor;
    }

    public static final class InsertEolAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            c.replaceSelection("\n");
        }
    }
}

