/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class OptionalDontShowMeAgainDialog {
    public static final int BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED = 1;
    public static final int ONLY_OK_SELECTION_IS_STORED = 0;
    public static final int ONLY_OK_SELECTION_IS_SHOWN = 2;
    private JDialog mDialog;
    private JCheckBox mDontShowAgainBox;
    private final String mMessageId;
    private final int mMessageType;
    private final NodeModel mNode;
    private final Frame mParent;
    private final String mPropertyName;
    private int mResult = 2;
    private final String mTitleId;

    public static int show(String pMessageId, String pTitleId, String pPropertyName, int pMessageType) {
        return new OptionalDontShowMeAgainDialog(pMessageId, pTitleId, pPropertyName, pMessageType).show().getResult();
    }

    private OptionalDontShowMeAgainDialog(String pMessageId, String pTitleId, String pPropertyName, int pMessageType) {
        Controller controller = Controller.getCurrentController();
        this.mParent = controller.getViewController().getFrame();
        IMapSelection selection = controller.getSelection();
        this.mNode = selection != null ? selection.getSelected() : null;
        this.mMessageId = pMessageId;
        this.mTitleId = pTitleId;
        this.mPropertyName = pPropertyName;
        this.mMessageType = pMessageType;
    }

    private void close(int pResult) {
        this.mResult = pResult;
        if (this.mDontShowAgainBox.isSelected()) {
            if (this.mMessageType == 0) {
                if (this.mResult == 0) {
                    this.setProperty("true");
                }
            } else {
                this.setProperty(this.mResult == 0 ? "true" : "false");
            }
        } else {
            this.setProperty("");
        }
        this.mDialog.setVisible(false);
        this.mDialog.dispose();
    }

    private String getProperty() {
        return ResourceController.getResourceController().getProperty(this.mPropertyName);
    }

    private int getResult() {
        return this.mResult;
    }

    private void setProperty(String value) {
        ResourceController.getResourceController().setProperty(this.mPropertyName, value);
    }

    private OptionalDontShowMeAgainDialog show() {
        String property = this.getProperty();
        if (StringUtils.equals((String)property, (String)"true")) {
            this.mResult = 0;
            return this;
        }
        if (this.mMessageType == 1 && StringUtils.equals((String)property, (String)"false")) {
            this.mResult = 2;
            return this;
        }
        this.mDialog = null;
        this.mDialog = new JDialog(this.mParent, TextUtils.getText(this.mTitleId));
        this.mDialog.setModal(true);
        this.mDialog.setDefaultCloseOperation(0);
        AbstractAction cancelAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(2);
            }
        };
        AbstractAction okAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(0);
            }
        };
        UITools.addEscapeActionToDialog(this.mDialog, cancelAction);
        this.mDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(2);
            }
        });
        this.mDialog.getContentPane().setLayout(new GridBagLayout());
        this.mDialog.getContentPane().add((Component)new JLabel(TextUtils.getText(this.mMessageId)), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        ImageIcon questionMark = this.mMessageType == 2 ? new ImageIcon(ResourceController.getResourceController().getResource("/images/icons/messagebox_warning.png")) : new ImageIcon(ResourceController.getResourceController().getResource("/images/icons/help.png"));
        this.mDialog.getContentPane().add((Component)new JLabel(questionMark), new GridBagConstraints(0, 0, 1, 2, 1.0, 2.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        String boxString = this.mMessageType != 1 ? "OptionalDontShowMeAgainDialog.dontShowAgain" : "OptionalDontShowMeAgainDialog.rememberMyDescision";
        this.mDontShowAgainBox = new JCheckBox(TextUtils.getRawText(boxString));
        MenuBuilder.setLabelAndMnemonic(this.mDontShowAgainBox, null);
        this.mDialog.getContentPane().add((Component)this.mDontShowAgainBox, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        String okText = this.mMessageType == 2 ? TextUtils.getRawText("ok") : TextUtils.getRawText("OptionalDontShowMeAgainDialog.ok");
        JButton okButton = new JButton(okText);
        MenuBuilder.setLabelAndMnemonic(okButton, null);
        okButton.addActionListener(okAction);
        this.mDialog.getContentPane().add((Component)okButton, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        if (this.mMessageType != 2) {
            JButton cancelButton = new JButton(TextUtils.getRawText("OptionalDontShowMeAgainDialog.cancel"));
            MenuBuilder.setLabelAndMnemonic(cancelButton, null);
            cancelButton.addActionListener(cancelAction);
            this.mDialog.getContentPane().add((Component)cancelButton, new GridBagConstraints(3, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        }
        this.mDialog.getRootPane().setDefaultButton(okButton);
        this.mDialog.pack();
        if (this.mNode != null) {
            UITools.setDialogLocationRelativeTo(this.mDialog, this.mNode);
        } else {
            this.mDialog.setLocationRelativeTo(null);
        }
        this.mDialog.setVisible(true);
        return this;
    }
}

