/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.freeplane.core.ui.components.JResizer;
import org.freeplane.core.ui.components.ResizeEvent;
import org.freeplane.core.util.LogUtils;

public class OneTouchCollapseResizer
extends JResizer {
    private static final long serialVersionUID = 3836146387249880446L;
    public static final String COLLAPSED = OneTouchCollapseResizer.class.getPackage().getName() + ".collapsed";
    private static final String ALREADY_IN_PAINT = OneTouchCollapseResizer.class.getPackage().getName() + ".ALREADY_PAINTING";
    private Dimension lastComponentSize;
    protected boolean expanded = true;
    private JPanel hotspot;
    private CollapseDirection collapseDirection;
    private int inset = 2;
    private final JResizer.Direction direction;
    private Integer resizeComponentIndex;
    private Set<ComponentCollapseListener> collapseListener = new LinkedHashSet<ComponentCollapseListener>();

    public OneTouchCollapseResizer(final JResizer.Direction d, CollapseDirection collapseDirection) {
        super(d);
        this.direction = d;
        this.setDividerSize(7);
        this.collapseDirection = collapseDirection;
        MouseListener listener = new MouseListener(){

            private void resetCursor() {
                if (d.equals((Object)JResizer.Direction.RIGHT)) {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (d.equals((Object)JResizer.Direction.LEFT)) {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(11));
                } else if (d.equals((Object)JResizer.Direction.UP)) {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(9));
                } else {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(8));
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
                if (e.getComponent() == OneTouchCollapseResizer.this.getHotSpot()) {
                    this.resetCursor();
                }
                if (OneTouchCollapseResizer.this.isExpanded()) {
                    this.resetCursor();
                }
            }

            public void mouseEntered(MouseEvent e) {
                if (e.getComponent() == OneTouchCollapseResizer.this.getHotSpot()) {
                    OneTouchCollapseResizer.this.getHotSpot().setCursor(Cursor.getPredefinedCursor(12));
                }
                if (!OneTouchCollapseResizer.this.isExpanded()) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            public void mouseClicked(MouseEvent e) {
                JComponent parent = (JComponent)OneTouchCollapseResizer.this.getParent();
                Component resizedComponent = OneTouchCollapseResizer.this.getResizedParent();
                if (e.getComponent() == OneTouchCollapseResizer.this.getHotSpot()) {
                    Dimension size = new Dimension(resizedComponent.getPreferredSize());
                    if (OneTouchCollapseResizer.this.isExpanded()) {
                        OneTouchCollapseResizer.this.getHotSpot().setEnabled(true);
                        OneTouchCollapseResizer.this.lastComponentSize = new Dimension(size);
                        OneTouchCollapseResizer.this.setExpanded(false);
                    } else {
                        OneTouchCollapseResizer.this.setExpanded(true);
                    }
                    parent.revalidate();
                    parent.repaint();
                } else if (!OneTouchCollapseResizer.this.isExpanded()) {
                    OneTouchCollapseResizer.this.setExpanded(true);
                    parent.revalidate();
                    parent.repaint();
                }
            }
        };
        this.getHotSpot().addMouseListener(listener);
        this.addMouseListener(listener);
        this.add(this.getHotSpot());
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setDividerSize(int size) {
        int h;
        int w;
        if (this.direction.equals((Object)JResizer.Direction.RIGHT)) {
            w = size;
            h = 0;
        } else if (this.direction.equals((Object)JResizer.Direction.LEFT)) {
            h = 0;
            w = size;
        } else if (this.direction.equals((Object)JResizer.Direction.UP)) {
            h = size;
            w = 0;
        } else {
            h = size;
            w = 0;
        }
        this.setPreferredSize(new Dimension(w, h));
    }

    public int getDividerSize() {
        if (this.direction.equals((Object)JResizer.Direction.RIGHT) || this.direction.equals((Object)JResizer.Direction.LEFT)) {
            return this.getPreferredSize().width;
        }
        return this.getPreferredSize().height;
    }

    public void setExpanded(boolean enabled) {
        if (this.expanded != enabled) {
            try {
                Component resizedComponent = this.getResizedParent();
                if (resizedComponent instanceof JComponent) {
                    ((JComponent)resizedComponent).putClientProperty(COLLAPSED, enabled ? null : "true");
                }
                if (enabled) {
                    if (this.lastComponentSize != null) {
                        resizedComponent.setPreferredSize(this.lastComponentSize);
                    }
                } else {
                    resizedComponent.setPreferredSize(new Dimension(0, 0));
                }
                this.fireCollapseStateChanged(resizedComponent, enabled);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.expanded = enabled;
    }

    private Component getResizedParent() {
        JComponent parent = (JComponent)this.getParent();
        if (parent != null && this.resizeComponentIndex == null) {
            this.resizeComponentIndex = this.getIndex();
            this.lastComponentSize = new Dimension(parent.getComponent(this.resizeComponentIndex).getPreferredSize());
        }
        return parent.getComponent(this.resizeComponentIndex);
    }

    public void paint(Graphics g) {
        if (this.getClientProperty(ALREADY_IN_PAINT) != null) {
            return;
        }
        this.putClientProperty(ALREADY_IN_PAINT, "true");
        super.paint(g);
        int center_y = this.getHeight() / 2;
        int divSize = this.getDividerSize();
        this.getHotSpot().setBounds(0, center_y - 15, divSize, 30);
        Dimension size = this.getResizedParent().getPreferredSize();
        if ((this.direction.equals((Object)JResizer.Direction.RIGHT) || this.direction.equals((Object)JResizer.Direction.LEFT)) && size.width <= this.getDividerSize()) {
            this.setExpanded(false);
        } else if ((this.direction.equals((Object)JResizer.Direction.UP) || this.direction.equals((Object)JResizer.Direction.DOWN)) && size.height <= this.getDividerSize()) {
            this.setExpanded(false);
        } else {
            this.setExpanded(true);
        }
        if (this.getResizedParent() instanceof JComponent) {
            ((JComponent)this.getResizedParent()).putClientProperty(COLLAPSED, this.isExpanded() ? null : "true");
        }
        this.getHotSpot().paint(g.create(this.getHotSpot().getLocation().x, this.getHotSpot().getLocation().y, this.getHotSpot().getWidth(), this.getHotSpot().getHeight()));
        this.putClientProperty(ALREADY_IN_PAINT, null);
    }

    private Component getHotSpot() {
        if (this.hotspot == null) {
            this.hotspot = new JPanel(){
                private static final long serialVersionUID = -5321517835206976034L;

                public void paint(Graphics g) {
                    if (OneTouchCollapseResizer.this.isExpanded()) {
                        OneTouchCollapseResizer.this.drawCollapseLabel(g);
                    } else {
                        OneTouchCollapseResizer.this.drawExpandLabel(g);
                    }
                }
            };
        }
        return this.hotspot;
    }

    private void drawCollapseLabel(Graphics g) {
        Dimension size = g.getClipBounds().getSize();
        int half_length = Math.round((float)g.getClipBounds().height * 0.2f);
        int center_y = size.height / 2;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height - 0);
        if (this.collapseDirection.equals((Object)CollapseDirection.COLLAPSE_LEFT)) {
            this.arrowLeft(g, size, half_length, center_y);
        } else if (this.collapseDirection.equals((Object)CollapseDirection.COLLAPSE_RIGHT)) {
            this.arrowRight(g, half_length, center_y);
        }
    }

    private void drawExpandLabel(Graphics g) {
        Dimension size = g.getClipBounds().getSize();
        int half_length = (g.getClipBounds().height - this.inset * 6) / 2;
        int center_y = size.height / 2;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height - 0);
        if (this.collapseDirection.equals((Object)CollapseDirection.COLLAPSE_LEFT)) {
            this.arrowRight(g, half_length, center_y);
        } else if (this.collapseDirection.equals((Object)CollapseDirection.COLLAPSE_RIGHT)) {
            this.arrowLeft(g, size, half_length, center_y);
        }
    }

    private void arrowLeft(Graphics g, Dimension size, int half_length, int center_y) {
        int[] x = new int[]{this.inset, size.width - this.inset, size.width - this.inset};
        int[] y = new int[]{center_y, center_y - half_length, center_y + half_length};
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(x, y, 3);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(this.inset, center_y, size.width - this.inset, center_y - half_length);
        g.setColor(Color.GRAY);
        g.drawLine(size.width - this.inset, center_y + half_length, this.inset, center_y);
        g.setColor(Color.GRAY);
        g.drawLine(size.width - this.inset, center_y - half_length, size.width - this.inset, center_y + half_length);
    }

    private void arrowRight(Graphics g, int half_length, int center_y) {
        int[] x = new int[]{this.inset, this.inset, this.getSize().width - this.inset};
        int[] y = new int[]{center_y + half_length, center_y - half_length, center_y};
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(x, y, 3);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(this.inset, center_y + half_length, this.inset, center_y - half_length);
        g.setColor(Color.GRAY);
        g.drawLine(this.inset, center_y - half_length, this.getSize().width - this.inset, center_y);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(this.getSize().width - this.inset, center_y, this.inset, center_y + half_length);
    }

    private int getIndex() {
        Container parent = this.getParent();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (!this.equals(parent.getComponent(i))) continue;
            if (this.direction.equals((Object)JResizer.Direction.RIGHT)) {
                return i + 1;
            }
            if (this.direction.equals((Object)JResizer.Direction.LEFT)) {
                return i - 1;
            }
            if (this.direction.equals((Object)JResizer.Direction.UP)) {
                return i - 1;
            }
            if (!this.direction.equals((Object)JResizer.Direction.DOWN)) continue;
            return i + 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollapseListener(ComponentCollapseListener listener) {
        if (listener == null) {
            return;
        }
        Set<ComponentCollapseListener> set = this.collapseListener;
        synchronized (set) {
            this.collapseListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollapseListener(ComponentCollapseListener listener) {
        if (listener == null) {
            return;
        }
        Set<ComponentCollapseListener> set = this.collapseListener;
        synchronized (set) {
            this.collapseListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCollapseStateChanged(Component resizedComponent, boolean expanded) {
        ResizeEvent event = new ResizeEvent(resizedComponent);
        Set<ComponentCollapseListener> set = this.collapseListener;
        synchronized (set) {
            for (ComponentCollapseListener listener : this.collapseListener) {
                try {
                    if (expanded) {
                        listener.componentExpanded(event);
                        continue;
                    }
                    listener.componentCollapsed(event);
                }
                catch (Exception e) {
                    LogUtils.severe(e);
                }
            }
        }
    }

    public static interface ComponentCollapseListener {
        public void componentCollapsed(ResizeEvent var1);

        public void componentExpanded(ResizeEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CollapseDirection {
        COLLAPSE_LEFT,
        COLLAPSE_RIGHT;

    }
}

