/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.components.ResizeEvent;
import org.freeplane.core.ui.components.ResizerListener;

public class JResizer
extends JComponent {
    private static final int CONTROL_SIZE = 5;
    private Point point;
    private int index;
    private Set<ResizerListener> resizeListener = new LinkedHashSet<ResizerListener>();

    public JResizer(final Direction d) {
        int h;
        int w;
        this.setOpaque(true);
        if (d.equals((Object)Direction.RIGHT)) {
            w = 5;
            h = 0;
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (d.equals((Object)Direction.LEFT)) {
            h = 5;
            w = 0;
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else if (d.equals((Object)Direction.UP)) {
            h = 0;
            w = 5;
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else {
            h = 0;
            w = 5;
            this.setCursor(Cursor.getPredefinedCursor(8));
        }
        this.setPreferredSize(new Dimension(w, h));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JResizer.this.point = null;
            }

            public void mouseReleased(MouseEvent e) {
                JResizer.this.point = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            private int getIndex() {
                Container parent = JResizer.this.getParent();
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    if (!JResizer.this.equals(parent.getComponent(i))) continue;
                    if (d.equals((Object)Direction.RIGHT)) {
                        return i + 1;
                    }
                    if (d.equals((Object)Direction.LEFT)) {
                        return i - 1;
                    }
                    if (d.equals((Object)Direction.UP)) {
                        return i - 1;
                    }
                    if (!d.equals((Object)Direction.DOWN)) continue;
                    return i + 1;
                }
                return -1;
            }

            public void mouseDragged(MouseEvent e) {
                Point point2 = e.getPoint();
                SwingUtilities.convertPointToScreen(point2, e.getComponent());
                if (JResizer.this.point != null) {
                    JComponent parent = (JComponent)JResizer.this.getParent();
                    Component resizedComponent = parent.getComponent(JResizer.this.index);
                    Dimension size = new Dimension(resizedComponent.getPreferredSize());
                    if (d.equals((Object)Direction.RIGHT)) {
                        size.width -= point2.x - ((JResizer)JResizer.this).point.x;
                    } else if (d.equals((Object)Direction.LEFT)) {
                        size.width += point2.x - ((JResizer)JResizer.this).point.x;
                    } else if (d.equals((Object)Direction.UP)) {
                        size.height += point2.x - ((JResizer)JResizer.this).point.x;
                    } else if (d.equals((Object)Direction.DOWN)) {
                        size.height -= point2.x - ((JResizer)JResizer.this).point.x;
                    }
                    resizedComponent.setPreferredSize(new Dimension(Math.max(size.width, 0), Math.max(size.height, 0)));
                    parent.revalidate();
                    parent.repaint();
                    JResizer.this.fireSizeChanged(resizedComponent);
                } else {
                    JResizer.this.index = this.getIndex();
                }
                JResizer.this.point = point2;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResizerListener(ResizerListener listener) {
        if (listener == null) {
            return;
        }
        Set<ResizerListener> set = this.resizeListener;
        synchronized (set) {
            this.resizeListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResizerListener(ComponentListener listener) {
        if (listener == null) {
            return;
        }
        Set<ResizerListener> set = this.resizeListener;
        synchronized (set) {
            this.resizeListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSizeChanged(Component resizedComponent) {
        ResizeEvent event = new ResizeEvent(resizedComponent);
        Set<ResizerListener> set = this.resizeListener;
        synchronized (set) {
            for (ResizerListener listener : this.resizeListener) {
                listener.componentResized(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        RIGHT,
        LEFT,
        UP,
        DOWN;

    }
}

