/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.freeplane.core.resources.NamedObject;

public class ContainerComboBoxEditor
implements ComboBoxEditor {
    private final Map<NamedObject, ComboBoxEditor> editors = new HashMap<NamedObject, ComboBoxEditor>();
    private ComboBoxEditor editor;
    private final JComboBox editorSelector;
    private final JPanel editorPanel;
    private Box editorComponent = Box.createHorizontalBox();
    private final List<ActionListener> actionListeners;

    public ContainerComboBoxEditor() {
        this.editorSelector = new JComboBox();
        this.editorSelector.setEditable(false);
        this.editorSelector.setRenderer(NamedObject.getIconRenderer());
        this.editorSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NamedObject key = (NamedObject)ContainerComboBoxEditor.this.editorSelector.getSelectedItem();
                ContainerComboBoxEditor.this.editor = (ComboBoxEditor)ContainerComboBoxEditor.this.editors.get(key);
                CardLayout layout = (CardLayout)ContainerComboBoxEditor.this.editorPanel.getLayout();
                layout.show(ContainerComboBoxEditor.this.editorPanel, key.getObject().toString());
                ContainerComboBoxEditor.this.editor.getEditorComponent().requestFocusInWindow();
                ActionEvent actionEvent = new ActionEvent(ContainerComboBoxEditor.this.editor, 0, null);
                for (ActionListener l : ContainerComboBoxEditor.this.actionListeners) {
                    l.actionPerformed(actionEvent);
                }
            }
        });
        this.editorComponent.add(this.editorSelector);
        this.editorPanel = new JPanel(new CardLayout(0, 0));
        this.editorComponent.add(this.editorPanel);
        this.actionListeners = new LinkedList<ActionListener>();
    }

    public boolean put(NamedObject key, ComboBoxEditor editor) {
        ComboBoxEditor oldEditor = this.editors.put(key, editor);
        if (oldEditor != null) {
            this.editors.put(key, oldEditor);
            return false;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.editorSelector.getModel();
        model.addElement(key);
        if (this.editor == null) {
            this.editor = editor;
        }
        this.editorPanel.add(editor.getEditorComponent(), key.getObject().toString());
        return true;
    }

    public Component getEditorComponent() {
        return this.editorComponent;
    }

    public void setItem(Object anObject) {
        if (anObject == null) {
            this.setItem("");
            return;
        }
        for (Map.Entry<NamedObject, ComboBoxEditor> editorEntry : this.editors.entrySet()) {
            ComboBoxEditor editor = editorEntry.getValue();
            editor.setItem(anObject);
            Object item = editor.getItem();
            NamedObject key = editorEntry.getKey();
            if (!anObject.equals(item) || key.equals(this.editorSelector.getSelectedItem())) continue;
            this.editorSelector.setSelectedItem(key);
            return;
        }
    }

    public Object getItem() {
        return this.editor.getItem();
    }

    public void selectAll() {
        this.editor.selectAll();
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
        for (ComboBoxEditor e : this.editors.values()) {
            e.addActionListener(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
        for (ComboBoxEditor e : this.editors.values()) {
            e.removeActionListener(l);
        }
    }
}

