/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import com.thebuzzmedia.imgscalr.AsyncScalr;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;

public class BitmapViewerComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private File cacheFile;
    private int hint;
    private BufferedImage cachedImage;
    private WeakReference<BufferedImage> cachedImageWeakRef;
    private final URL url;
    private final Dimension originalSize;
    private int imageX;
    private int imageY;
    private boolean processing;
    private boolean scaleEnabled;
    private static final Object LOCK;

    public boolean isScaleEnabled() {
        return this.scaleEnabled;
    }

    public void setScaleEnabled(boolean scaleEnabled) {
        this.scaleEnabled = scaleEnabled;
    }

    protected int getHint() {
        return this.hint;
    }

    public void setHint(int hint) {
        this.hint = hint;
    }

    public BitmapViewerComponent(URI uri) throws MalformedURLException, IOException {
        this.url = uri.toURL();
        this.originalSize = this.readOriginalSize();
        this.hint = 4;
        this.processing = false;
        this.scaleEnabled = true;
        this.cachedImage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension readOriginalSize() throws IOException {
        InputStream inputStream = null;
        ImageInputStream in = null;
        try {
            inputStream = this.url.openStream();
            in = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    return dimension;
                }
                finally {
                    reader.dispose();
                }
            }
            throw new IOException("can not create image");
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public Dimension getOriginalSize() {
        return new Dimension(this.originalSize);
    }

    protected void paintComponent(Graphics g) {
        if (this.processing) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.cachedImage == null && this.cachedImageWeakRef != null) {
            this.cachedImage = (BufferedImage)this.cachedImageWeakRef.get();
            this.cachedImageWeakRef = null;
        }
        if (this.cachedImage == null && this.cacheFile != null) {
            this.loadImageFromCacheFile();
        }
        if (!this.isCachedImageValid()) {
            BufferedImage tempImage;
            try {
                tempImage = ImageIO.read(this.url);
            }
            catch (IOException e) {
                return;
            }
            final BufferedImage image = tempImage;
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (imageWidth == 0 || imageHeight == 0) {
                return;
            }
            this.processing = true;
            final Future<BufferedImage> result = AsyncScalr.resize(image, this.getWidth(), this.getHeight(), new BufferedImageOp[0]);
            AsyncScalr.getService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    BufferedImage scaledImage = null;
                    try {
                        scaledImage = (BufferedImage)result.get();
                    }
                    catch (Exception e) {
                        LogUtils.severe(e);
                        return;
                    }
                    finally {
                        image.flush();
                    }
                    int scaledImageHeight = scaledImage.getHeight();
                    int scaledImageWidth = scaledImage.getWidth();
                    if (scaledImageHeight > BitmapViewerComponent.this.getHeight()) {
                        BitmapViewerComponent.this.imageX = 0;
                        BitmapViewerComponent.this.imageY = (BitmapViewerComponent.this.getHeight() - scaledImageHeight) / 2;
                    } else {
                        BitmapViewerComponent.this.imageX = (BitmapViewerComponent.this.getWidth() - scaledImageWidth) / 2;
                        BitmapViewerComponent.this.imageY = 0;
                    }
                    BitmapViewerComponent.this.cachedImage = scaledImage;
                    if (BitmapViewerComponent.this.getCacheType().equals((Object)CacheType.IC_FILE)) {
                        BitmapViewerComponent.this.writeCacheFile();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            BitmapViewerComponent.this.processing = false;
                            BitmapViewerComponent.this.repaint();
                        }
                    });
                }
            });
        } else {
            g.drawImage(this.cachedImage, this.imageX, this.imageY, null);
            this.flushImage();
        }
    }

    private void flushImage() {
        CacheType cacheType = this.getCacheType();
        if (CacheType.IC_RAM.equals((Object)cacheType)) {
            this.cachedImage.flush();
        } else {
            this.cachedImageWeakRef = new WeakReference<BufferedImage>(this.cachedImage);
            this.cachedImage = null;
        }
    }

    private CacheType getCacheType() {
        return ResourceController.getResourceController().getEnumProperty("image_cache", CacheType.IC_DISABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCacheFile() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"), "freeplane");
        tempDir.mkdirs();
        try {
            Object object = LOCK;
            synchronized (object) {
                this.cacheFile = File.createTempFile("cachedImage", ".jpg", tempDir);
            }
            ImageIO.write((RenderedImage)this.cachedImage, "jpg", this.cacheFile);
        }
        catch (IOException e) {
            this.cacheFile.delete();
            this.cacheFile = null;
        }
    }

    private boolean isCachedImageValid() {
        return this.cachedImage != null && (!this.scaleEnabled || 1 >= Math.abs(this.getWidth() - this.cachedImage.getWidth()) && this.getHeight() >= this.cachedImage.getHeight() || this.getWidth() >= this.cachedImage.getWidth() && 1 >= Math.abs(this.getHeight() - this.cachedImage.getHeight()));
    }

    private void loadImageFromCacheFile() {
        try {
            this.cachedImage = ImageIO.read(this.cacheFile);
            if (this.isCachedImageValid()) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cacheFile.delete();
        this.cacheFile = null;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.cacheFile != null) {
            this.cacheFile.delete();
            this.cacheFile = null;
        }
    }

    static {
        AsyncScalr.setServiceThreadCount(1);
        LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CacheType {
        IC_DISABLE,
        IC_FILE,
        IC_RAM;

    }
}

