/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freeplane.core.ui.IndexedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIBuilder
extends IndexedTree {
    public static final int ICON_SIZE = 16;

    public UIBuilder(Object root) {
        super(root);
    }

    protected void addComponent(Container container, Component component, int index) {
        container.add(component, index);
    }

    protected void addComponent(DefaultMutableTreeNode childNode, int position) {
        int index;
        Container parentComponent = this.getParentComponent(childNode, Container.class);
        if (parentComponent == null) {
            return;
        }
        if (position == 0 && ((DefaultMutableTreeNode)childNode.getParent()).getUserObject() instanceof Container) {
            index = this.getParentComponentCount(parentComponent) - 1;
        } else {
            Component relative = this.getPrevious(childNode);
            index = -1;
            if (relative != null) {
                Container nextParentComponent = parentComponent;
                block0: while (nextParentComponent != null) {
                    parentComponent = nextParentComponent;
                    for (int i = 0; i < this.getParentComponentCount(parentComponent); ++i) {
                        if (this.getChildComponent(parentComponent, i) != relative) continue;
                        index = i;
                        break block0;
                    }
                    nextParentComponent = this.getNextParentComponent(nextParentComponent);
                }
            }
        }
        if (position != -1) {
            ++index;
        }
        Component component = (Component)childNode.getUserObject();
        this.addComponent(parentComponent, component, index);
    }

    protected Container getNextParentComponent(Container parentComponent) {
        return null;
    }

    @Override
    protected void addNode(DefaultMutableTreeNode relativeNode, DefaultMutableTreeNode node, int position) {
        super.addNode(relativeNode, node, position);
        if (node.getUserObject() instanceof Component) {
            this.addComponent(node, position);
        }
    }

    protected Component getChildComponent(Container parentComponent, int index) {
        return parentComponent.getComponent(index);
    }

    protected Container getContainer(DefaultMutableTreeNode node, Class<?> clazz) {
        if (node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (clazz.isInstance(userObject)) {
            return (Container)userObject;
        }
        return this.getParentComponent(node, clazz);
    }

    Container getParentComponent(DefaultMutableTreeNode child, Class<?> clazz) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
        return this.getContainer(parent, clazz);
    }

    protected int getParentComponentCount(Container parentComponent) {
        return parentComponent.getComponentCount();
    }

    protected Component getPrevious(DefaultMutableTreeNode childNode) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)childNode.getParent();
        if (parentNode == null || parentNode.getUserObject() == null) {
            return null;
        }
        int childNodeIndex = parentNode.getIndex(childNode);
        Component c = this.getPrevious(parentNode, childNodeIndex - 1);
        if (c == null) {
            return this.getPrevious(parentNode);
        }
        return c;
    }

    private Component getPrevious(TreeNode parentNode, int last) {
        for (int i = last; i >= 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            Object userObject = child.getUserObject();
            if (userObject instanceof Component) {
                return (Component)userObject;
            }
            Component childComponent = this.getPrevious(child, child.getChildCount() - 1);
            if (childComponent == null) continue;
            return childComponent;
        }
        return null;
    }

    protected void removeChildComponents(Container parentComponent, DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Component) {
            Component component = (Component)userObject;
            parentComponent.remove(component);
            return;
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            Object userObject2 = child.getUserObject();
            if (userObject2 instanceof Component) {
                parentComponent.remove((Component)userObject2);
                continue;
            }
            this.removeChildComponents(parentComponent, child);
        }
    }

    @Override
    public void removeChildElements(Object key) {
        DefaultMutableTreeNode node = this.getNode(key);
        Container parentComponent = this.getContainer(node, Container.class);
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            IndexedTree.Node child = (IndexedTree.Node)children.nextElement();
            this.removeChildComponents(parentComponent, child);
        }
        super.removeChildElements(key);
    }

    @Override
    public DefaultMutableTreeNode removeElement(Object key) {
        DefaultMutableTreeNode node = super.removeElement(key);
        Container parentComponent = this.getParentComponent(node, Container.class);
        if (parentComponent == null || node == null) {
            return node;
        }
        this.removeChildComponents(parentComponent, node);
        ((DefaultMutableTreeNode)node.getParent()).remove(node);
        if (parentComponent.isShowing()) {
            parentComponent.validate();
            parentComponent.repaint();
        }
        return node;
    }
}

