/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MenuBuilder;

public class MenuSplitter {
    private static final String EXTRA_SUBMENU = MenuBuilder.class.getName() + ".extra_submenu";
    private static final int MAX_MENU_ITEM_COUNT = ResourceController.getResourceController().getIntProperty("max_menu_item_count");
    public static int count = 0;

    public void addMenuComponent(JMenu menu, Component component, int index) {
        JPopupMenu popupMenu = menu.getPopupMenu();
        int itemCount = popupMenu.getComponentCount();
        if (index == 0 || index < itemCount) {
            popupMenu.insert(component, index);
        } else {
            Component lastMenuItem = popupMenu.getComponent(itemCount - 1);
            boolean extraSubMenu = this.isExtraSubMenu(lastMenuItem);
            if (extraSubMenu || !this.fitsOnScreen(popupMenu, component)) {
                JMenu submenu;
                if (extraSubMenu) {
                    submenu = (JMenu)lastMenuItem;
                } else {
                    if (component instanceof JPopupMenu.Separator) {
                        return;
                    }
                    submenu = new JMenu("");
                    submenu.putClientProperty(EXTRA_SUBMENU, Boolean.TRUE);
                    popupMenu.add(submenu);
                }
                this.addMenuComponent(submenu, component, submenu.getPopupMenu().getComponentCount());
            } else {
                popupMenu.insert(component, index);
            }
        }
    }

    private boolean fitsOnScreen(JPopupMenu popupMenu, Component component) {
        int itemCount = popupMenu.getComponentCount();
        return itemCount < MAX_MENU_ITEM_COUNT && popupMenu.getPreferredSize().height + component.getPreferredSize().height < MenuBuilder.MAX_HEIGHT;
    }

    public boolean hasExtraSubMenu(JMenu menu) {
        Component lastComponent = menu.getComponent(menu.getComponentCount() - 1);
        return this.isExtraSubMenu(lastComponent);
    }

    public boolean isExtraSubMenu(Component c) {
        return c instanceof JMenu && Boolean.TRUE.equals(((JMenu)c).getClientProperty(EXTRA_SUBMENU));
    }

    public JMenu getExtraSubMenu(JMenu parentComponent) {
        Component lastComponent = parentComponent.getComponent(parentComponent.getComponentCount() - 1);
        if (new MenuSplitter().isExtraSubMenu(lastComponent)) {
            return (JMenu)lastComponent;
        }
        return null;
    }
}

