/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.SetBooleanPropertyAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.AccelerateableAction;
import org.freeplane.core.ui.IAcceleratorChangeListener;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.IndexedTree;
import org.freeplane.core.ui.MenuSplitter;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.ui.UIBuilder;
import org.freeplane.core.ui.components.JAutoCheckBoxMenuItem;
import org.freeplane.core.ui.components.JAutoRadioButtonMenuItem;
import org.freeplane.core.ui.components.JAutoToggleButton;
import org.freeplane.core.ui.components.JFreeplaneMenuItem;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBuilder
extends UIBuilder {
    private static Insets nullInsets = new Insets(0, 0, 0, 0);
    private static final String SHORTCUT_PROPERTY_PREFIX = "acceleratorFor";
    static final int MAX_HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().height - 100;
    private IAcceleratorChangeListener acceleratorChangeListener;
    private final Map<KeyStroke, IndexedTree.Node> accelerators = new HashMap<KeyStroke, IndexedTree.Node>();
    private final ModeController modeController;
    final MenuStructureReader reader;
    private Set<String> plugins;

    public static JMenu createMenu(String name) {
        JMenu menu = new JMenu();
        String text = TextUtils.getRawText(name);
        MenuBuilder.setLabelAndMnemonic(menu, text);
        return menu;
    }

    public static JMenuItem createMenuItem(String name) {
        JFreeplaneMenuItem menu = new JFreeplaneMenuItem();
        String text = TextUtils.getRawText(name);
        MenuBuilder.setLabelAndMnemonic(menu, text);
        return menu;
    }

    public static void loadAcceleratorPresets(InputStream in) {
        Properties prop = new Properties();
        try {
            prop.load(in);
            for (Map.Entry<Object, Object> property : prop.entrySet()) {
                KeyStroke keyStroke;
                String shortcutKey = (String)property.getKey();
                String keystrokeString = (String)property.getValue();
                if (!shortcutKey.startsWith(SHORTCUT_PROPERTY_PREFIX)) {
                    LogUtils.warn("wrong property key " + shortcutKey);
                    continue;
                }
                int pos = shortcutKey.indexOf("/", SHORTCUT_PROPERTY_PREFIX.length());
                if (pos <= 0) {
                    LogUtils.warn("wrong property key " + shortcutKey);
                    continue;
                }
                String modeName = shortcutKey.substring(SHORTCUT_PROPERTY_PREFIX.length(), pos);
                String itemKey = shortcutKey.substring(pos + 1);
                Controller controller = Controller.getCurrentController();
                ModeController modeController = controller.getModeController(modeName);
                if (modeController == null) {
                    LogUtils.warn("unknown mode name in " + shortcutKey);
                    continue;
                }
                MenuBuilder menuBuilder = modeController.getUserInputListenerFactory().getMenuBuilder();
                IndexedTree.Node node = (IndexedTree.Node)menuBuilder.get(itemKey);
                if (node == null) {
                    LogUtils.warn("wrong key in " + shortcutKey);
                    continue;
                }
                Object obj = node.getUserObject();
                if (!(obj instanceof JMenuItem)) {
                    LogUtils.warn("wrong key in " + shortcutKey);
                    continue;
                }
                if (!keystrokeString.equals("")) {
                    keyStroke = UITools.getKeyStroke(keystrokeString);
                    IndexedTree.Node oldNode = menuBuilder.getMenuItemForKeystroke(keyStroke);
                    if (oldNode != null) {
                        menuBuilder.setAccelerator(oldNode, null);
                        Object key = oldNode.getKey();
                        String oldShortcutKey = menuBuilder.getShortcutKey(key.toString());
                        ResourceController.getResourceController().setProperty(oldShortcutKey, "");
                    }
                } else {
                    keyStroke = null;
                }
                menuBuilder.setAccelerator(node, keyStroke);
                ResourceController.getResourceController().setProperty(shortcutKey, keystrokeString);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setLabelAndMnemonic(AbstractButton btn, String inLabel) {
        MenuBuilder.setLabelAndMnemonic(new ButtonHolder(btn), inLabel);
    }

    public static void setLabelAndMnemonic(Action action, String inLabel) {
        MenuBuilder.setLabelAndMnemonic(new ActionHolder(action), inLabel);
    }

    private static void setLabelAndMnemonic(INameMnemonicHolder item, String inLabel) {
        char charAfterMnemoSign;
        String rawLabel = inLabel;
        if (rawLabel == null) {
            rawLabel = item.getText();
        }
        if (rawLabel == null) {
            return;
        }
        item.setText(TextUtils.removeMnemonic(rawLabel));
        int mnemoSignIndex = rawLabel.indexOf(38);
        if (mnemoSignIndex >= 0 && mnemoSignIndex + 1 < rawLabel.length() && (charAfterMnemoSign = rawLabel.charAt(mnemoSignIndex + 1)) != ' ' && !Compat.isMacOsX()) {
            item.setMnemonic(charAfterMnemoSign);
            item.setDisplayedMnemonicIndex(mnemoSignIndex);
        }
    }

    public MenuBuilder(ModeController modeController) {
        super(null);
        this.modeController = modeController;
        this.reader = new MenuStructureReader();
    }

    private void setDefaultAccelerator(String itemKey, String accelerator) {
        String shortcutKey = this.getShortcutKey(itemKey);
        if (null == ResourceController.getResourceController().getProperty(shortcutKey, null)) {
            ResourceController.getResourceController().setDefaultProperty(shortcutKey, accelerator);
        }
    }

    public void addAction(String category, AFreeplaneAction action, int position) {
        String menuKey = this.getMenuKey(category, action.getKey());
        this.addAction(category, menuKey, action, position);
    }

    public String getMenuKey(String category, String actionKey) {
        actionKey = "$" + actionKey + '$';
        for (int i = 0; i < 1000; ++i) {
            String key = actionKey + i;
            if (null != this.get(key)) continue;
            return key;
        }
        return category + '/' + actionKey;
    }

    public void addAction(String category, String key, AFreeplaneAction action, int position) {
        assert (action != null);
        assert (key != null);
        if (this.getContainer(this.get(category), Container.class) instanceof JToolBar) {
            this.addButton(category, action, key, position);
            return;
        }
        JMenuItem item = action.getClass().getAnnotation(SelectableAction.class) != null ? new JAutoCheckBoxMenuItem(this.decorateAction(category, action)) : new JFreeplaneMenuItem(this.decorateAction(category, action));
        this.addMenuItem(category, item, key, position);
        this.addListeners(key, action);
    }

    private void addListeners(String key, final AFreeplaneAction action) {
        if (AFreeplaneAction.checkSelectionOnPopup(action)) {
            this.addPopupMenuListener(key, new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (action.isEnabled()) {
                        action.setSelected();
                    }
                }
            });
        }
    }

    private void addButton(String category, Action action, String key, int position) {
        assert (action != null);
        AbstractButton button = action.getClass().getAnnotation(SelectableAction.class) != null ? new JAutoToggleButton(action) : new JButton(action);
        this.addElement(category, button, key, position);
    }

    @Override
    protected void addComponent(Container container, Component component, int index) {
        if (container instanceof JMenu) {
            new MenuSplitter().addMenuComponent((JMenu)container, component, index);
            return;
        }
        if (container instanceof JToolBar && component instanceof AbstractButton) {
            ((AbstractButton)component).setMargin(nullInsets);
        }
        super.addComponent(container, component, index);
    }

    public void addComponent(String parent, Container item, Action action, int position) {
        action.addPropertyChangeListener(new Enabler(item));
        this.addElement(parent, item, position);
    }

    public void addMenuBar(JMenuBar menubar, String key) {
        this.addElement(this, menubar, key, 0);
    }

    public void addMenuItem(String relativeKey, JMenuItem item, String key, int position) {
        String shortcutKey = this.getShortcutKey(key);
        String keyStrokeString = ResourceController.getResourceController().getProperty(shortcutKey);
        IndexedTree.Node element = (IndexedTree.Node)this.addElement(relativeKey, item, key, position);
        if (null == this.getMenuBar(element)) {
            return;
        }
        if (keyStrokeString != null && !keyStrokeString.equals("")) {
            KeyStroke keyStroke = UITools.getKeyStroke(keyStrokeString);
            this.setAccelerator(element, keyStroke);
        }
    }

    public void addMenuItemGroup(String key, int position) {
        this.addElement(this, key, key, position);
    }

    public void addMenuItemGroup(String relativeKey, String key, int position) {
        this.addElement(relativeKey, key, key, position);
    }

    public void addPopupMenu(JPopupMenu menu, String key) {
        this.addElement(this, menu, key, 0);
    }

    public void addPopupMenuListener(Object key, PopupMenuListener listener) {
        JPopupMenu popup;
        DefaultMutableTreeNode node = this.get(key);
        assert (node != null);
        if (node.getUserObject() instanceof JMenu) {
            popup = ((JMenu)node.getUserObject()).getPopupMenu();
        } else if (node.getUserObject() instanceof JPopupMenu) {
            popup = (JPopupMenu)node.getUserObject();
        } else {
            Container container = this.getContainer((DefaultMutableTreeNode)node.getParent(), Container.class);
            if (container instanceof JPopupMenu) {
                popup = (JPopupMenu)container;
            } else if (container instanceof JMenu) {
                popup = ((JMenu)container).getPopupMenu();
            } else {
                throw new RuntimeException("no popup menu found!");
            }
        }
        Object userObject = node.getUserObject();
        popup.addPopupMenuListener(new DelegatingPopupMenuListener(listener, userObject));
    }

    public JMenuItem addRadioItem(String category, AFreeplaneAction action, boolean isSelected) {
        assert (action != null);
        String actionKey = "$" + action.getKey() + '$';
        for (int i = 0; i < 1000; ++i) {
            String key = actionKey + i;
            if (null != this.get(key)) continue;
            return this.addRadioItem(category, key, action, isSelected);
        }
        return this.addRadioItem(category, category + '/' + actionKey, action, isSelected);
    }

    public JMenuItem addRadioItem(String category, String key, AFreeplaneAction action, boolean isSelected) {
        assert (key != null);
        JRadioButtonMenuItem item = action.getClass().getAnnotation(SelectableAction.class) != null ? new JAutoRadioButtonMenuItem(this.decorateAction(category, action)) : new JRadioButtonMenuItem(this.decorateAction(category, action));
        this.addMenuItem(category, item, key, 0);
        item.setSelected(isSelected);
        this.addListeners(key, action);
        return item;
    }

    public void addSeparator() {
        this.addElement(this, new JPopupMenu.Separator(), 0);
    }

    public void addSeparator(String parentKey, int position) {
        Container parent = this.getContainer(this.get(parentKey), Container.class);
        if (parent instanceof JMenu || parent instanceof JPopupMenu) {
            this.addElement(parentKey, new JPopupMenu.Separator(), position);
            return;
        }
        if (parent instanceof JToolBar) {
            JToolBar t = (JToolBar)parent;
            JToolBar.Separator s = new JToolBar.Separator();
            this.addElement(parentKey, s, position);
            if (t.getOrientation() == 1) {
                s.setOrientation(0);
            } else {
                s.setOrientation(1);
            }
            return;
        }
    }

    public void addToolbar(JToolBar toolbar, String key) {
        this.addElement(this, toolbar, key, 0);
    }

    public void afterMapChange(MapModel newMap) {
        Iterator<Object> iterator = this.newObjectIterator();
        while (iterator.hasNext()) {
            AbstractButton btn;
            Action action;
            Object next = iterator.next();
            if (!(next instanceof AbstractButton) || !((action = (btn = (AbstractButton)next).getAction()) instanceof IFreeplaneAction)) continue;
            ((IFreeplaneAction)action).afterMapChange(newMap);
        }
    }

    IFreeplaneAction decorateAction(String category, AFreeplaneAction action) {
        if (null == this.getMenuBar(this.get(category)) || Controller.getCurrentController().getViewController().isApplet()) {
            return action;
        }
        return this.decorateAction(action);
    }

    public IFreeplaneAction decorateAction(AFreeplaneAction action) {
        return new AccelerateableAction(this, action);
    }

    public IAcceleratorChangeListener getAcceleratorChangeListener() {
        return this.acceleratorChangeListener;
    }

    @Override
    protected Component getChildComponent(Container parentComponent, int index) {
        if (parentComponent instanceof JMenu) {
            return ((JMenu)parentComponent).getMenuComponent(index);
        }
        return super.getChildComponent(parentComponent, index);
    }

    @Override
    protected Container getNextParentComponent(Container parentComponent) {
        if (parentComponent.getComponentCount() > 0 && parentComponent instanceof JMenu) {
            return new MenuSplitter().getExtraSubMenu((JMenu)parentComponent);
        }
        return null;
    }

    public IndexedTree.Node getMenuBar(DefaultMutableTreeNode element) {
        while (element != null) {
            Object userObject = element.getUserObject();
            if (userObject instanceof JMenuBar) {
                return (IndexedTree.Node)element;
            }
            element = (DefaultMutableTreeNode)element.getParent();
        }
        return null;
    }

    private IndexedTree.Node getMenuItemForKeystroke(KeyStroke keyStroke) {
        return this.accelerators.get(keyStroke);
    }

    @Override
    protected DefaultMutableTreeNode getNode(Object parentKey) {
        DefaultMutableTreeNode parentNode = super.getNode(parentKey);
        return parentNode;
    }

    @Override
    protected int getParentComponentCount(Container parentComponent) {
        if (parentComponent instanceof JMenu) {
            return ((JMenu)parentComponent).getMenuComponentCount();
        }
        return super.getParentComponentCount(parentComponent);
    }

    public String getShortcutKey(String key) {
        return SHORTCUT_PROPERTY_PREFIX + this.modeController.getModeName() + "/" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMenuCategory(URL menu, Set<String> plugins) {
        Set<String> oldPlugins = this.plugins;
        this.plugins = plugins;
        try {
            this.reader.processMenu(menu);
        }
        finally {
            this.plugins = oldPlugins;
        }
    }

    private KeyStroke removeAccelerator(IndexedTree.Node node) throws AssertionError {
        IndexedTree.Node oldNode;
        KeyStroke oldAccelerator = ((JMenuItem)node.getUserObject()).getAccelerator();
        if (oldAccelerator != null && !node.equals(oldNode = this.accelerators.remove(oldAccelerator))) {
            throw new AssertionError((Object)("unexpected action for accelerator " + oldAccelerator));
        }
        return oldAccelerator;
    }

    private void removeAccelerators(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof JMenuItem && !(userObject instanceof JMenu)) {
            this.setAccelerator((IndexedTree.Node)node, null);
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.removeAccelerators((DefaultMutableTreeNode)children.nextElement());
        }
    }

    @Override
    protected void removeChildComponents(Container parentComponent, DefaultMutableTreeNode node) {
        this.removeAccelerators(node);
        if (parentComponent instanceof JMenu) {
            JMenu menu = (JMenu)parentComponent;
            JPopupMenu popupMenu = menu.getPopupMenu();
            super.removeChildComponents(popupMenu, node);
            for (int i = popupMenu.getComponentCount() - 1; i >= 0; --i) {
                Component component = popupMenu.getComponent(i);
                if (!new MenuSplitter().isExtraSubMenu(component)) continue;
                Container container = (Container)component;
                super.removeChildComponents(container, node);
                if (container.getComponentCount() != 0) continue;
                popupMenu.remove(container);
            }
        } else {
            super.removeChildComponents(parentComponent, node);
        }
    }

    public void removePopupMenuListener(Object key, PopupMenuListener listener) {
        JPopupMenu popup;
        DefaultMutableTreeNode node = this.get(key);
        Container container = this.getContainer(node, Container.class);
        if (container instanceof JPopupMenu) {
            popup = (JPopupMenu)container;
        } else if (container instanceof JMenu) {
            popup = ((JMenu)container).getPopupMenu();
        } else {
            throw new RuntimeException("no popup menu found!");
        }
        Object userObject = node.getUserObject();
        PopupMenuListener[] popupMenuListeners = popup.getPopupMenuListeners();
        for (int i = 0; i < popupMenuListeners.length; ++i) {
            PopupMenuListener popupMenuListener = popupMenuListeners[i];
            if (!(popupMenuListener instanceof DelegatingPopupMenuListener) || ((DelegatingPopupMenuListener)popupMenuListener).getSource() != userObject) continue;
            popup.removePopupMenuListener(popupMenuListener);
            break;
        }
    }

    void setAccelerator(IndexedTree.Node node, KeyStroke keyStroke) {
        IndexedTree.Node oldAction = this.accelerators.put(keyStroke, node);
        JMenuItem item = (JMenuItem)node.getUserObject();
        if (keyStroke != null && oldAction != null) {
            UITools.errorMessage(TextUtils.format("action_keystroke_in_use_error", keyStroke, item.getActionCommand(), ((JMenuItem)oldAction.getUserObject()).getActionCommand()));
            this.accelerators.put(keyStroke, oldAction);
            String shortcutKey = this.getShortcutKey(node.getKey().toString());
            ResourceController.getResourceController().setProperty(shortcutKey, "");
            return;
        }
        if (item instanceof JMenu) {
            UITools.errorMessage(TextUtils.format("submenu_keystroke_in_use_error", keyStroke, item.getText()));
            this.accelerators.put(keyStroke, oldAction);
            String shortcutKey = this.getShortcutKey(node.getKey().toString());
            ResourceController.getResourceController().setProperty(shortcutKey, "");
            return;
        }
        KeyStroke removedAccelerator = this.removeAccelerator(node);
        item.setAccelerator(keyStroke);
        if (this.acceleratorChangeListener != null && (removedAccelerator != null || keyStroke != null)) {
            this.acceleratorChangeListener.acceleratorChanged(item, removedAccelerator, keyStroke);
        }
    }

    public void setAcceleratorChangeListener(IAcceleratorChangeListener acceleratorChangeListener) {
        this.acceleratorChangeListener = acceleratorChangeListener;
    }

    public Map<KeyStroke, IndexedTree.Node> getAcceleratorMap() {
        return Collections.unmodifiableMap(this.accelerators);
    }

    private class MenuStructureReader {
        private ButtonGroup buttonGroup;
        private final ReadManager readManager = new ReadManager();

        public MenuStructureReader() {
            this.readManager.addElementHandler("menu_structure", new StructureCreator());
            this.readManager.addElementHandler("menu_category", new CategoryCreator());
            this.readManager.addElementHandler("menu_submenu", new CategoryCreator());
            this.readManager.addElementHandler("menu_action", new ActionCreator());
            this.readManager.addElementHandler("menu_radio_action", new ActionCreator());
            this.readManager.addElementHandler("menu_separator", new SeparatorCreator());
        }

        public void processMenu(URL menu) {
            InputStreamReader streamReader = null;
            try {
                streamReader = new InputStreamReader(new BufferedInputStream(menu.openStream()));
                TreeXmlReader reader = new TreeXmlReader(this.readManager);
                reader.load(streamReader);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    FileUtils.silentlyClose(streamReader);
                    throw throwable;
                }
            }
            FileUtils.silentlyClose(streamReader);
        }

        private final class StructureCreator
        implements IElementHandler {
            private StructureCreator() {
            }

            public Object createElement(Object parent, String tag, XMLElement attributes) {
                return MenuPath.emptyPath();
            }
        }

        private final class SeparatorCreator
        implements IElementHandler {
            private SeparatorCreator() {
            }

            public Object createElement(Object parent, String tag, XMLElement attributes) {
                MenuBuilder.this.addSeparator(parent.toString(), 0);
                return parent;
            }
        }

        private final class CategoryCreator
        implements IElementHandler {
            private CategoryCreator() {
            }

            public Object createElement(Object parent, String tag, XMLElement attributes) {
                if (attributes == null) {
                    return null;
                }
                String plugin = attributes.getAttribute("plugin", null);
                if (plugin != null && !MenuBuilder.this.plugins.contains(plugin)) {
                    return null;
                }
                MenuStructureReader.this.buttonGroup = null;
                MenuPath menuPath = new MenuPath(parent.toString());
                String menuKey = attributes.getAttribute("menu_key", null);
                if (menuKey == null) {
                    menuPath.setLastKeySection(attributes.getAttribute("name", null));
                } else {
                    menuPath.setKey(menuKey);
                }
                if (!MenuBuilder.this.contains(menuPath.key)) {
                    if (tag.equals("menu_submenu")) {
                        JMenu menuItem = new JMenu();
                        String nameRef = attributes.getAttribute("name_ref", null);
                        if (nameRef == null) {
                            nameRef = attributes.getAttribute("name", null);
                        }
                        String iconResource = ResourceController.getResourceController().getProperty(nameRef + ".icon", null);
                        MenuBuilder.setLabelAndMnemonic(menuItem, TextUtils.getRawText(nameRef));
                        if (iconResource != null) {
                            URL url = ResourceController.getResourceController().getResource(iconResource);
                            menuItem.setIcon(new ImageIcon(url));
                        }
                        MenuBuilder.this.addMenuItem(menuPath.parentKey, menuItem, menuPath.key, 0);
                    } else if (!menuPath.parentKey.equals("")) {
                        MenuBuilder.this.addMenuItemGroup(menuPath.parentKey, menuPath.key, 0);
                    }
                }
                return menuPath;
            }
        }

        private final class ActionCreator
        implements IElementHandler {
            private ActionCreator() {
            }

            public Object createElement(Object parent, String tag, XMLElement attributes) {
                if (attributes == null) {
                    return null;
                }
                MenuPath menuPath = new MenuPath(parent.toString());
                String action = attributes.getAttribute("action", null);
                String plugin = attributes.getAttribute("plugin", null);
                if (plugin != null && !MenuBuilder.this.plugins.contains(plugin)) {
                    return null;
                }
                try {
                    String menuKey;
                    AFreeplaneAction theAction = MenuBuilder.this.modeController.getAction(action);
                    if (theAction == null) {
                        if (action.startsWith("SetBooleanPropertyAction.")) {
                            String propertyName = action.substring("SetBooleanPropertyAction.".length());
                            theAction = new SetBooleanPropertyAction(propertyName);
                            MenuBuilder.this.modeController.addAction(theAction);
                        } else {
                            LogUtils.severe("action " + action + " not found");
                            return null;
                        }
                    }
                    if ((menuKey = attributes.getAttribute("menu_key", null)) == null) {
                        menuKey = MenuBuilder.this.getMenuKey(menuPath.parentKey, theAction.getKey());
                    }
                    menuPath.setKey(menuKey);
                    String accelerator = attributes.getAttribute("accelerator", null);
                    if (accelerator != null) {
                        if (Compat.isMacOsX()) {
                            accelerator = accelerator.replaceFirst("CONTROL", "META").replaceFirst("control", "meta");
                        }
                        MenuBuilder.this.setDefaultAccelerator(menuPath.key, accelerator);
                    }
                    if (tag.equals("menu_radio_action")) {
                        JRadioButtonMenuItem item = (JRadioButtonMenuItem)MenuBuilder.this.addRadioItem(menuPath.parentKey, menuPath.key, theAction, "true".equals(attributes.getAttribute("selected", "false")));
                        if (MenuStructureReader.this.buttonGroup == null) {
                            MenuStructureReader.this.buttonGroup = new ButtonGroup();
                        }
                        MenuStructureReader.this.buttonGroup.add(item);
                    } else {
                        MenuBuilder.this.addAction(menuPath.parentKey, menuPath.key, theAction, 0);
                    }
                }
                catch (Exception e) {
                    LogUtils.severe(e);
                }
                return menuPath;
            }
        }
    }

    private static class MenuPath {
        String parentKey;
        String key;

        static MenuPath emptyPath() {
            MenuPath menuPath = new MenuPath("");
            menuPath.key = "";
            return menuPath;
        }

        MenuPath(String key) {
            this.parentKey = key;
        }

        void setKey(String name) {
            this.key = name;
        }

        void setLastKeySection(String name) {
            this.key = this.parentKey + '/' + name;
        }

        public String toString() {
            return this.key;
        }
    }

    static interface INameMnemonicHolder {
        public String getText();

        public void setDisplayedMnemonicIndex(int var1);

        public void setMnemonic(char var1);

        public void setText(String var1);
    }

    private static class Enabler
    implements PropertyChangeListener {
        private final WeakReference<Component> comp;

        public Enabler(Component comp) {
            this.comp = new WeakReference<Component>(comp);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Component component = (Component)this.comp.get();
            if (component == null) {
                Action action = (Action)evt.getSource();
                action.removePropertyChangeListener(this);
            } else if (evt.getPropertyName().equals("enabled")) {
                Action action = (Action)evt.getSource();
                component.setEnabled(action.isEnabled());
            }
        }
    }

    private static class DelegatingPopupMenuListener
    implements PopupMenuListener {
        private final PopupMenuListener listener;
        private final Object source;

        public DelegatingPopupMenuListener(PopupMenuListener listener, Object source) {
            this.listener = listener;
            this.source = source;
        }

        public Object getSource() {
            return this.source;
        }

        private PopupMenuEvent newEvent() {
            return new PopupMenuEvent(this.source);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            this.listener.popupMenuCanceled(this.newEvent());
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.listener.popupMenuWillBecomeInvisible(this.newEvent());
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.listener.popupMenuWillBecomeVisible(this.newEvent());
        }
    }

    public static class ButtonHolder
    implements INameMnemonicHolder {
        private final AbstractButton btn;

        public ButtonHolder(AbstractButton btn) {
            this.btn = btn;
        }

        public String getText() {
            return this.btn.getText();
        }

        public void setDisplayedMnemonicIndex(int mnemoSignIndex) {
            this.btn.setDisplayedMnemonicIndex(mnemoSignIndex);
        }

        public void setMnemonic(char charAfterMnemoSign) {
            this.btn.setMnemonic(charAfterMnemoSign);
        }

        public void setText(String text) {
            this.btn.setText(text);
        }
    }

    private static class ActionHolder
    implements INameMnemonicHolder {
        private final Action action;

        public ActionHolder(Action action) {
            this.action = action;
        }

        public String getText() {
            return (String)this.action.getValue("Name");
        }

        public void setDisplayedMnemonicIndex(int mnemoSignIndex) {
            this.action.putValue("SwingDisplayedMnemonicIndexKey", mnemoSignIndex);
        }

        public void setMnemonic(char charAfterMnemoSign) {
            int vk = charAfterMnemoSign;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            this.action.putValue("MnemonicKey", new Integer(vk));
        }

        public void setText(String text) {
            this.action.putValue("Name", text);
        }
    }
}

