/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.GrabKeyDialog;
import org.freeplane.core.resources.components.IKeystrokeValidator;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.IndexedTree;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.IKeyBindingManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;

public class AccelerateableAction
implements IFreeplaneAction {
    private final MenuBuilder menuBuilder;
    private final AFreeplaneAction originalAction;
    private static JDialog setAcceleratorOnNextClickActionDialog;
    private static KeyStroke acceleratorForNextClickedAction;
    private static final String SET_ACCELERATOR_ON_NEXT_CLICK_ACTION = "set_accelerator_on_next_click_action";

    static boolean isNewAcceleratorOnNextClickEnabled() {
        return setAcceleratorOnNextClickActionDialog != null;
    }

    static void setNewAcceleratorOnNextClick(KeyStroke accelerator) {
        if (AccelerateableAction.isNewAcceleratorOnNextClickEnabled()) {
            return;
        }
        acceleratorForNextClickedAction = accelerator;
        String title = TextUtils.getText("SetAccelerator.dialogTitle");
        String text = TextUtils.getText(SET_ACCELERATOR_ON_NEXT_CLICK_ACTION);
        if (accelerator != null) {
            text = TextUtils.format("SetAccelerator.keystrokeDetected", AccelerateableAction.toString(accelerator)) + "\n" + text;
        }
        Frame frame = Controller.getCurrentController().getViewController().getFrame();
        setAcceleratorOnNextClickActionDialog = UITools.createCancelDialog(frame, title, text);
        setAcceleratorOnNextClickActionDialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                setAcceleratorOnNextClickActionDialog = null;
                acceleratorForNextClickedAction = null;
            }
        });
        setAcceleratorOnNextClickActionDialog.setVisible(true);
    }

    public AccelerateableAction(MenuBuilder menuBuilder, AFreeplaneAction originalAction) {
        this.menuBuilder = menuBuilder;
        this.originalAction = originalAction;
    }

    public void actionPerformed(ActionEvent e) {
        boolean newAcceleratorOnNextClickEnabled = AccelerateableAction.isNewAcceleratorOnNextClickEnabled();
        KeyStroke newAccelerator = acceleratorForNextClickedAction;
        if (newAcceleratorOnNextClickEnabled) {
            setAcceleratorOnNextClickActionDialog.setVisible(false);
        }
        Object source = e.getSource();
        if ((newAcceleratorOnNextClickEnabled || 0 != (e.getModifiers() & 2)) && source instanceof IKeyBindingManager && !((IKeyBindingManager)source).isKeyBindingProcessed() && source instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)source;
            this.newAccelerator(item, newAccelerator);
            return;
        }
        this.originalAction.actionPerformed(e);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.originalAction.addPropertyChangeListener(listener);
    }

    public void afterMapChange(Object newMap) {
        this.originalAction.afterMapChange(newMap);
    }

    public Object getValue(String key) {
        return this.originalAction.getValue(key);
    }

    public boolean isEnabled() {
        return this.originalAction.isEnabled();
    }

    public boolean isSelected() {
        return this.originalAction.isSelected();
    }

    public void setSelected(boolean newValue) {
        this.originalAction.setSelected(newValue);
    }

    public void newAccelerator(JMenuItem editedItem, KeyStroke newAccelerator) {
        Object key = this.menuBuilder.getKeyByUserObject(editedItem);
        String shortcutKey = this.menuBuilder.getShortcutKey(key.toString());
        String oldShortcut = ResourceController.getResourceController().getProperty(shortcutKey);
        if (newAccelerator == null || !new KeystrokeValidator(editedItem, key, editedItem).isValid(newAccelerator, Character.valueOf(newAccelerator.getKeyChar()))) {
            GrabKeyDialog grabKeyDialog = new GrabKeyDialog(oldShortcut);
            KeystrokeValidator validator = new KeystrokeValidator(grabKeyDialog, key, editedItem);
            grabKeyDialog.setValidator(validator);
            grabKeyDialog.setVisible(true);
            if (grabKeyDialog.isOK()) {
                String shortcut = grabKeyDialog.getShortcut();
                KeyStroke accelerator = UITools.getKeyStroke(shortcut);
                this.menuBuilder.setAccelerator((IndexedTree.Node)this.menuBuilder.get(key), accelerator);
                ResourceController.getResourceController().setProperty(shortcutKey, shortcut);
                LogUtils.info("created shortcut '" + shortcut + "' for menuitem '" + key + "', shortcutKey '" + shortcutKey + "' (" + editedItem.getText() + ")");
            }
        } else {
            int replace;
            if (oldShortcut != null && (replace = JOptionPane.showConfirmDialog(editedItem, oldShortcut, TextUtils.getText("remove_shortcut_question"), 0)) != 0) {
                return;
            }
            this.menuBuilder.setAccelerator((IndexedTree.Node)this.menuBuilder.get(key), newAccelerator);
            ResourceController.getResourceController().setProperty(shortcutKey, AccelerateableAction.toString(newAccelerator));
            LogUtils.info("created shortcut '" + AccelerateableAction.toString(newAccelerator) + "' for menuitem '" + key + "', shortcutKey '" + shortcutKey + "' (" + editedItem.getText() + ")");
        }
    }

    private static String toString(KeyStroke newAccelerator) {
        return newAccelerator.toString().replaceFirst("pressed ", "");
    }

    private static boolean askForReplaceShortcutViaDialog(String oldMenuItemTitle, Component parentComponent) {
        int replace = JOptionPane.showConfirmDialog(parentComponent, TextUtils.format("replace_shortcut_question", oldMenuItemTitle), TextUtils.format("replace_shortcut_title", new Object[0]), 0);
        return replace == 0;
    }

    public void putValue(String key, Object value) {
        this.originalAction.putValue(key, value);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.originalAction.removePropertyChangeListener(listener);
    }

    public void setEnabled(boolean b) {
        this.originalAction.setEnabled(b);
    }

    public String getIconKey() {
        return this.originalAction.getIconKey();
    }

    private class KeystrokeValidator
    implements IKeystrokeValidator {
        private final Component parentComponent;
        private final Object key;
        private final JMenuItem editedItem;

        private KeystrokeValidator(Component parentComponent, Object key, JMenuItem editedItem) {
            this.parentComponent = parentComponent;
            this.key = key;
            this.editedItem = editedItem;
        }

        private boolean checkForOverwriteShortcut(DefaultMutableTreeNode menubarNode, KeyStroke keystroke) {
            IndexedTree.Node priorAssigned = MenuUtils.findAssignedMenuItemNodeRecursively(menubarNode, keystroke);
            if (priorAssigned == null || this.editedItem.equals(priorAssigned.getUserObject())) {
                return true;
            }
            return this.replaceOrCancel(priorAssigned, ((JMenuItem)priorAssigned.getUserObject()).getText());
        }

        private boolean replaceOrCancel(IndexedTree.Node menuItemNode, String oldMenuItemTitle) {
            if (AccelerateableAction.askForReplaceShortcutViaDialog(oldMenuItemTitle, this.parentComponent)) {
                AccelerateableAction.this.menuBuilder.setAccelerator(menuItemNode, null);
                String shortcutKey = AccelerateableAction.this.menuBuilder.getShortcutKey(menuItemNode.getKey().toString());
                ResourceController.getResourceController().setProperty(shortcutKey, "");
                return true;
            }
            return false;
        }

        public boolean isValid(KeyStroke keystroke, Character keyChar) {
            if (keystroke == null) {
                return true;
            }
            IndexedTree.Node menuBarNode = AccelerateableAction.this.menuBuilder.getMenuBar(AccelerateableAction.this.menuBuilder.get(this.key));
            if (menuBarNode == null) {
                return true;
            }
            if (keyChar.charValue() != '\uffff' && (keystroke.getModifiers() & 0xE) == 0) {
                String keyTypeActionString = ResourceController.getResourceController().getProperty("key_type_action", IEditHandler.FirstAction.EDIT_CURRENT.toString());
                IEditHandler.FirstAction keyTypeAction = IEditHandler.FirstAction.valueOf(keyTypeActionString);
                return IEditHandler.FirstAction.IGNORE.equals((Object)keyTypeAction);
            }
            if ((keystroke.getModifiers() & 0xE) == 8) {
                JMenuBar menuBar = (JMenuBar)menuBarNode.getUserObject();
                int menuCount = menuBar.getMenuCount();
                for (int i = 0; i < menuCount; ++i) {
                    JMenu menu = menuBar.getMenu(i);
                    char c = (char)menu.getMnemonic();
                    if (Character.toLowerCase(keystroke.getKeyCode()) != Character.toLowerCase(c)) continue;
                    JOptionPane.showMessageDialog(this.parentComponent, menu.getText(), TextUtils.getText("used_in_menu"), 2);
                    return false;
                }
            }
            if (!this.checkForOverwriteShortcut(menuBarNode, keystroke)) {
                return false;
            }
            KeyStroke derivedKS = FreeplaneMenuBar.derive(keystroke, keyChar);
            if (derivedKS == keystroke) {
                return true;
            }
            return this.checkForOverwriteShortcut(menuBarNode, derivedKS);
        }
    }
}

